/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class Chunk3D
extends ChunkPos {
    public final ResourceKey<Level> dimension;

    public Chunk3D(ResourceKey<Level> dimension, int x, int z) {
        super(x, z);
        this.dimension = dimension;
    }

    public Chunk3D(ResourceKey<Level> dimension, long chunkPos) {
        this(dimension, ChunkPos.getX((long)chunkPos), ChunkPos.getZ((long)chunkPos));
    }

    public Chunk3D(ResourceKey<Level> dimension, ChunkPos chunkPos) {
        this(dimension, chunkPos.x, chunkPos.z);
    }

    public Chunk3D(GlobalPos pos) {
        this((ResourceKey<Level>)pos.dimension(), SectionPos.blockToSectionCoord((int)pos.pos().getX()), SectionPos.blockToSectionCoord((int)pos.pos().getZ()));
    }

    public Set<Chunk3D> expand(int chunkRadius) {
        if (chunkRadius < 0) {
            throw new IllegalArgumentException("Chunk radius cannot be negative.");
        }
        if (chunkRadius == 1) {
            return Collections.singleton(this);
        }
        HashSet<Chunk3D> ret = new HashSet<Chunk3D>();
        for (int i = this.x - chunkRadius; i <= this.x + chunkRadius; ++i) {
            for (int j = this.z - chunkRadius; j <= this.z + chunkRadius; ++j) {
                ret.add(new Chunk3D(this.dimension, i, j));
            }
        }
        return ret;
    }

    @NotNull
    public String toString() {
        return "[Chunk3D: " + this.x + ", " + this.z + ", dim=" + this.dimension.location() + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Chunk3D)) return false;
        Chunk3D other = (Chunk3D)((Object)obj);
        if (other.x != this.x) return false;
        if (other.z != this.z) return false;
        if (other.dimension != this.dimension) return false;
        return true;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.x;
        code = 31 * code + this.z;
        code = 31 * code + this.dimension.hashCode();
        return code;
    }
}

