/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasBuilder;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfuseTypeBuilder;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentBuilder;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryBuilder;
import mekanism.api.gear.ModuleData;
import mekanism.api.robit.RobitSkin;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.slf4j.Logger;

@NothingNullByDefault
public class MekanismAPI {
    public static final String API_VERSION = "10.5.20";
    public static final String MEKANISM_MODID = "mekanism";
    public static boolean debug = false;
    public static final Logger logger = LogUtils.getLogger();
    public static final ResourceKey<Registry<Gas>> GAS_REGISTRY_NAME = MekanismAPI.registryKey(Gas.class, "gas");
    public static final ResourceKey<Registry<InfuseType>> INFUSE_TYPE_REGISTRY_NAME = MekanismAPI.registryKey(InfuseType.class, "infuse_type");
    public static final ResourceKey<Registry<Pigment>> PIGMENT_REGISTRY_NAME = MekanismAPI.registryKey(Pigment.class, "pigment");
    public static final ResourceKey<Registry<Slurry>> SLURRY_REGISTRY_NAME = MekanismAPI.registryKey(Slurry.class, "slurry");
    public static final ResourceKey<Registry<ModuleData<?>>> MODULE_REGISTRY_NAME = MekanismAPI.registryKey(ModuleData.class, "module");
    public static final ResourceKey<Registry<RobitSkin>> ROBIT_SKIN_REGISTRY_NAME = MekanismAPI.registryKey(RobitSkin.class, "robit_skin");
    public static final ResourceKey<Registry<Codec<? extends RobitSkin>>> ROBIT_SKIN_SERIALIZER_REGISTRY_NAME = MekanismAPI.codecRegistryKey(RobitSkin.class, "robit_skin_serializer");
    public static final Registry<Gas> GAS_REGISTRY = new RegistryBuilder(GAS_REGISTRY_NAME).defaultKey(MekanismAPI.rl("empty")).sync(true).create();
    public static final Registry<InfuseType> INFUSE_TYPE_REGISTRY = new RegistryBuilder(INFUSE_TYPE_REGISTRY_NAME).defaultKey(MekanismAPI.rl("empty")).sync(true).create();
    public static final Registry<Pigment> PIGMENT_REGISTRY = new RegistryBuilder(PIGMENT_REGISTRY_NAME).defaultKey(MekanismAPI.rl("empty")).sync(true).create();
    public static final Registry<Slurry> SLURRY_REGISTRY = new RegistryBuilder(SLURRY_REGISTRY_NAME).defaultKey(MekanismAPI.rl("empty")).sync(true).create();
    public static final Registry<ModuleData<?>> MODULE_REGISTRY = new RegistryBuilder(MODULE_REGISTRY_NAME).sync(true).create();
    public static final Registry<Codec<? extends RobitSkin>> ROBIT_SKIN_SERIALIZER_REGISTRY = new RegistryBuilder(ROBIT_SKIN_SERIALIZER_REGISTRY_NAME).create();
    public static final Gas EMPTY_GAS = new Gas((GasBuilder)GasBuilder.builder().hidden());
    public static final InfuseType EMPTY_INFUSE_TYPE = new InfuseType((InfuseTypeBuilder)InfuseTypeBuilder.builder().hidden());
    public static final Pigment EMPTY_PIGMENT = new Pigment((PigmentBuilder)PigmentBuilder.builder().hidden());
    public static final Slurry EMPTY_SLURRY = new Slurry((SlurryBuilder)SlurryBuilder.clean().hidden());

    private MekanismAPI() {
    }

    private static ResourceLocation rl(String path) {
        return new ResourceLocation(MEKANISM_MODID, path);
    }

    private static <T> ResourceKey<Registry<T>> registryKey(Class<T> compileTimeTypeValidator, String path) {
        return ResourceKey.createRegistryKey((ResourceLocation)MekanismAPI.rl(path));
    }

    private static <T> ResourceKey<Registry<Codec<? extends T>>> codecRegistryKey(Class<T> compileTimeTypeValidator, String path) {
        return ResourceKey.createRegistryKey((ResourceLocation)MekanismAPI.rl(path));
    }
}

