/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.ChemicalUtils;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.crafting.CraftingHelper;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class SerializerHelper {
    public static final Codec<Long> POSITIVE_LONG_CODEC = (Codec)Util.make(() -> {
        Function checker = Codec.checkRange((Number)0L, (Number)Long.MAX_VALUE);
        return Codec.LONG.flatXmap(checker, checker);
    });
    public static final Codec<Long> POSITIVE_NONZERO_LONG_CODEC = (Codec)Util.make(() -> {
        Function checker = Codec.checkRange((Number)1L, (Number)Long.MAX_VALUE);
        return Codec.LONG.flatXmap(checker, checker);
    });
    private static final Codec<Fluid> NON_EMPTY_FLUID_CODEC = ExtraCodecs.validate((Codec)BuiltInRegistries.FLUID.byNameCodec(), fluid -> fluid == Fluids.EMPTY ? DataResult.error(() -> "Invalid fluid type") : DataResult.success((Object)fluid));
    public static final Codec<FluidStack> FLUIDSTACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NON_EMPTY_FLUID_CODEC.fieldOf("fluid").forGetter(FluidStack::getFluid), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(FluidStack::getAmount), (App)CraftingHelper.TAG_CODEC.optionalFieldOf("nbt").forGetter(stack -> Optional.ofNullable(stack.getTag()))).apply((Applicative)instance, (fluid, amount, tag) -> {
        FluidStack stack = new FluidStack(fluid, amount.intValue());
        tag.ifPresent(arg_0 -> ((FluidStack)stack).setTag(arg_0));
        return stack;
    }));
    public static final Codec<ChemicalStack<?>> BOXED_CHEMICALSTACK_CODEC = ChemicalType.CODEC.dispatch("chemicalType", ChemicalType::getTypeFor, type -> switch (type) {
        default -> throw new IncompatibleClassChangeError();
        case ChemicalType.GAS -> ChemicalUtils.GAS_STACK_CODEC;
        case ChemicalType.INFUSION -> ChemicalUtils.INFUSION_STACK_CODEC;
        case ChemicalType.PIGMENT -> ChemicalUtils.PIGMENT_STACK_CODEC;
        case ChemicalType.SLURRY -> ChemicalUtils.SLURRY_STACK_CODEC;
    });

    private SerializerHelper() {
    }

    @NotNull
    public static <SOURCE, THIS_TYPE> RecordCodecBuilder<SOURCE, Optional<THIS_TYPE>> dependentOptionality(RecordCodecBuilder<SOURCE, ? extends Optional<?>> primaryField, final MapCodec<Optional<THIS_TYPE>> dependentCodec, Function<SOURCE, Optional<THIS_TYPE>> dependentGetter) {
        MapDecoder.Implementation dependentRequired = new MapDecoder.Implementation<Optional<THIS_TYPE>>(){

            public <T> DataResult<Optional<THIS_TYPE>> decode(DynamicOps<T> ops, MapLike<T> input) {
                DataResult thisField = dependentCodec.decode(ops, input);
                if (thisField.error().isPresent() || thisField.result().orElse(Optional.empty()).isPresent()) {
                    return thisField;
                }
                return DataResult.error(() -> "Missing value");
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return dependentCodec.keys(ops);
            }
        };
        return primaryField.dependent(dependentGetter, dependentCodec, arg_0 -> SerializerHelper.lambda$dependentOptionality$8(dependentCodec, (MapDecoder.Implementation)dependentRequired, arg_0));
    }

    @NotNull
    public static <SOURCE, THIS_TYPE> RecordCodecBuilder<SOURCE, Optional<THIS_TYPE>> oneRequired(RecordCodecBuilder<SOURCE, ? extends Optional<?>> otherField, final MapCodec<Optional<THIS_TYPE>> dependentCodec, Function<SOURCE, Optional<THIS_TYPE>> dependentGetter) {
        MapDecoder.Implementation dependentRequired = new MapDecoder.Implementation<Optional<THIS_TYPE>>(){

            public <T> DataResult<Optional<THIS_TYPE>> decode(DynamicOps<T> ops, MapLike<T> input) {
                DataResult thisField = dependentCodec.decode(ops, input);
                if (thisField.error().isPresent() || thisField.result().orElse(Optional.empty()).isPresent()) {
                    return thisField;
                }
                return DataResult.error(() -> 2.getFieldNames(dependentCodec) + " is required");
            }

            private static <THIS_TYPE> String getFieldNames(MapCodec<Optional<THIS_TYPE>> codec) {
                return codec.keys((DynamicOps)JsonOps.INSTANCE).map(JsonElement::getAsString).collect(Collectors.joining());
            }

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return dependentCodec.keys(ops);
            }
        };
        return otherField.dependent(dependentGetter, dependentCodec, arg_0 -> SerializerHelper.lambda$oneRequired$9(dependentCodec, (MapDecoder.Implementation)dependentRequired, arg_0));
    }

    private static /* synthetic */ MapDecoder lambda$oneRequired$9(MapCodec dependentCodec, MapDecoder.Implementation dependentRequired, Optional primaryValue) {
        return primaryValue.isPresent() ? dependentCodec : dependentRequired;
    }

    private static /* synthetic */ MapDecoder lambda$dependentOptionality$8(MapCodec dependentCodec, MapDecoder.Implementation dependentRequired, Optional primaryValue) {
        return primaryValue.isEmpty() ? dependentCodec : dependentRequired;
    }
}

