/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.IChemicalAttributeContainer;
import mekanism.api.chemical.gas.attribute.GasAttributes;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.text.TextComponentUtil;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class Chemical<CHEMICAL extends Chemical<CHEMICAL>>
implements IChemicalProvider<CHEMICAL>,
IChemicalAttributeContainer<CHEMICAL> {
    private final Map<Class<? extends ChemicalAttribute>, ChemicalAttribute> attributeMap;
    private final ResourceLocation iconLocation;
    private final boolean hidden;
    private final int tint;
    private boolean isRadioactive;
    private boolean hasAttributesWithValidation;
    @Nullable
    private String translationKey;

    protected Chemical(ChemicalBuilder<CHEMICAL, ?> builder) {
        this.attributeMap = new HashMap<Class<ChemicalAttribute>, ChemicalAttribute>(builder.getAttributeMap());
        this.iconLocation = builder.getTexture();
        this.tint = builder.getTint();
        this.hidden = builder.isHidden();
        this.isRadioactive = this.attributeMap.containsKey(GasAttributes.Radiation.class);
        this.hasAttributesWithValidation = this.isRadioactive || this.attributeMap.values().stream().anyMatch(ChemicalAttribute::needsValidation);
    }

    @Override
    @NotNull
    public CHEMICAL getChemical() {
        return (CHEMICAL)this;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = this.getDefaultTranslationKey();
        }
        return this.translationKey;
    }

    @Override
    public boolean has(Class<? extends ChemicalAttribute> type) {
        return this.attributeMap.containsKey(type);
    }

    public boolean isRadioactive() {
        return this.isRadioactive;
    }

    public boolean hasAttributesWithValidation() {
        return this.hasAttributesWithValidation;
    }

    @Override
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE get(Class<ATTRIBUTE> type) {
        return (ATTRIBUTE)this.attributeMap.get(type);
    }

    public void addAttribute(ChemicalAttribute attribute) {
        this.attributeMap.put(attribute.getClass(), attribute);
        if (attribute instanceof GasAttributes.Radiation) {
            this.isRadioactive = true;
            this.hasAttributesWithValidation = true;
        } else if (attribute.needsValidation()) {
            this.hasAttributesWithValidation = true;
        }
    }

    @Override
    public Collection<ChemicalAttribute> getAttributes() {
        return this.attributeMap.values();
    }

    @Override
    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return this.attributeMap.keySet();
    }

    public abstract CompoundTag write(CompoundTag var1);

    protected abstract String getDefaultTranslationKey();

    @Override
    public Component getTextComponent() {
        return TextComponentUtil.translate(this.getTranslationKey());
    }

    public ResourceLocation getIcon() {
        return this.iconLocation;
    }

    public int getTint() {
        return this.tint;
    }

    public int getColorRepresentation() {
        return this.getTint();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean is(TagKey<CHEMICAL> tag) {
        return this.getRegistry().wrapAsHolder((Object)this).is(tag);
    }

    public Stream<TagKey<CHEMICAL>> getTags() {
        return this.getRegistry().wrapAsHolder((Object)this).tags();
    }

    public abstract boolean isEmptyType();

    @Override
    public ResourceLocation getRegistryName() {
        return this.getRegistry().getKey((Object)this);
    }

    protected abstract Registry<CHEMICAL> getRegistry();
}

