/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiFunction;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.attribute.IChemicalAttributeContainer;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class ChemicalStack<CHEMICAL extends Chemical<CHEMICAL>>
implements IHasTextComponent,
IHasTranslationKey,
IChemicalAttributeContainer<ChemicalStack<CHEMICAL>> {
    private boolean isEmpty;
    private long amount;
    private final CHEMICAL chemical;

    protected static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> Codec<STACK> codec(Codec<CHEMICAL> chemicalCodec, String chemicalField, BiFunction<CHEMICAL, Long, STACK> constructor) {
        return RecordCodecBuilder.create(i -> i.group((App)chemicalCodec.fieldOf(chemicalField).forGetter(ChemicalStack::getRaw), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStack::getAmount)).apply((Applicative)i, constructor));
    }

    protected ChemicalStack(CHEMICAL chemical, long amount) {
        Objects.requireNonNull(chemical, "Cannot create a ChemicalStack from a null chemical");
        if (!this.getRegistry().containsValue(chemical)) {
            throw new IllegalArgumentException("Cannot create a ChemicalStack from an unregistered Chemical");
        }
        this.chemical = chemical;
        this.amount = amount;
        this.updateEmpty();
    }

    protected abstract Registry<CHEMICAL> getRegistry();

    protected abstract CHEMICAL getEmptyChemical();

    public abstract ChemicalStack<CHEMICAL> copy();

    public final CHEMICAL getType() {
        return this.isEmpty ? this.getEmptyChemical() : this.getRaw();
    }

    public boolean isTypeEqual(ChemicalStack<CHEMICAL> stack) {
        return this.isTypeEqual(stack.getType());
    }

    public boolean isTypeEqual(CHEMICAL chemical) {
        return this.getType() == chemical;
    }

    public ResourceLocation getTypeRegistryName() {
        return ((Chemical)this.getType()).getRegistryName();
    }

    public int getChemicalTint() {
        return ((Chemical)this.getType()).getTint();
    }

    public int getChemicalColorRepresentation() {
        return ((Chemical)this.getType()).getColorRepresentation();
    }

    private CHEMICAL getRaw() {
        return this.chemical;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    protected void updateEmpty() {
        this.isEmpty = ((Chemical)this.getRaw()).isEmptyType() || this.amount <= 0L;
    }

    public long getAmount() {
        return this.isEmpty ? 0L : this.amount;
    }

    public void setAmount(long amount) {
        if (((Chemical)this.getRaw()).isEmptyType()) {
            throw new IllegalStateException("Can't modify the empty stack.");
        }
        this.amount = amount;
        this.updateEmpty();
    }

    public void grow(long amount) {
        this.setAmount(this.amount + amount);
    }

    public void shrink(long amount) {
        this.setAmount(this.amount - amount);
    }

    @Override
    public boolean has(Class<? extends ChemicalAttribute> type) {
        return ((Chemical)this.getType()).has(type);
    }

    public boolean isRadioactive() {
        return ((Chemical)this.getType()).isRadioactive();
    }

    @Override
    @Nullable
    public <ATTRIBUTE extends ChemicalAttribute> ATTRIBUTE get(Class<ATTRIBUTE> type) {
        return ((Chemical)this.getType()).get(type);
    }

    @Override
    public Collection<ChemicalAttribute> getAttributes() {
        return ((Chemical)this.getType()).getAttributes();
    }

    @Override
    public Collection<Class<? extends ChemicalAttribute>> getAttributeTypes() {
        return ((Chemical)this.getType()).getAttributeTypes();
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + this.getType().hashCode();
        code = 31 * code + Long.hashCode(this.getAmount());
        return code;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChemicalStack other = (ChemicalStack)o;
        return this.getType() == other.getType() && this.getAmount() == other.getAmount();
    }

    public String toString() {
        return "[" + this.getType() + ", " + this.amount + "]";
    }

    @Override
    public Component getTextComponent() {
        return ((Chemical)this.getType()).getTextComponent();
    }

    @Override
    public String getTranslationKey() {
        return ((Chemical)this.getType()).getTranslationKey();
    }

    public boolean contains(ChemicalStack<CHEMICAL> other) {
        return this.isTypeEqual((CHEMICAL)other) && this.amount >= other.amount;
    }

    public boolean isStackIdentical(ChemicalStack<CHEMICAL> other) {
        return this.isTypeEqual((CHEMICAL)other) && this.amount == other.amount;
    }

    public CompoundTag write(CompoundTag nbtTags) {
        ((Chemical)this.getType()).write(nbtTags);
        nbtTags.putLong("amount", this.getAmount());
        return nbtTags;
    }

    public void writeToPacket(FriendlyByteBuf buffer) {
        buffer.writeId(this.getRegistry(), this.getType());
        if (!this.isEmpty()) {
            buffer.writeVarLong(this.getAmount());
        }
    }
}

