/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import java.util.function.Predicate;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.IPigmentTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.ISlurryTank;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ChemicalType implements StringRepresentable
{
    GAS("gas", c -> c instanceof Gas),
    INFUSION("infuse_type", c -> c instanceof InfuseType),
    PIGMENT("pigment", c -> c instanceof Pigment),
    SLURRY("slurry", c -> c instanceof Slurry);

    private static final Map<String, ChemicalType> nameToType;
    public static final Codec<ChemicalType> CODEC;
    private final Predicate<Chemical<?>> instanceCheck;
    private final String name;

    private ChemicalType(String name, Predicate<Chemical<?>> instanceCheck) {
        this.name = name;
        this.instanceCheck = instanceCheck;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public boolean isInstance(Chemical<?> chemical) {
        return this.instanceCheck.test(chemical);
    }

    public void write(@NotNull CompoundTag nbt) {
        nbt.putString("chemicalType", this.getSerializedName());
    }

    @Nullable
    public static ChemicalType fromString(String name) {
        return nameToType.get(name);
    }

    @Nullable
    public static ChemicalType fromNBT(@Nullable CompoundTag nbt) {
        if (nbt != null && nbt.contains("chemicalType", 8)) {
            return ChemicalType.fromString(nbt.getString("chemicalType"));
        }
        return null;
    }

    public static ChemicalType getTypeFor(Chemical<?> chemical) {
        if (chemical instanceof Gas) {
            return GAS;
        }
        if (chemical instanceof InfuseType) {
            return INFUSION;
        }
        if (chemical instanceof Pigment) {
            return PIGMENT;
        }
        if (chemical instanceof Slurry) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical type");
    }

    public static ChemicalType getTypeFor(ChemicalStack<?> stack) {
        return ChemicalType.getTypeFor(stack.getType());
    }

    public static ChemicalType getTypeFor(ChemicalStackIngredient<?, ?> ingredient) {
        if (ingredient instanceof ChemicalStackIngredient.GasStackIngredient) {
            return GAS;
        }
        if (ingredient instanceof ChemicalStackIngredient.InfusionStackIngredient) {
            return INFUSION;
        }
        if (ingredient instanceof ChemicalStackIngredient.PigmentStackIngredient) {
            return PIGMENT;
        }
        if (ingredient instanceof ChemicalStackIngredient.SlurryStackIngredient) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical ingredient type");
    }

    public static ChemicalType getTypeFor(IChemicalHandler<?, ?> handler) {
        if (handler instanceof IGasHandler) {
            return GAS;
        }
        if (handler instanceof IInfusionHandler) {
            return INFUSION;
        }
        if (handler instanceof IPigmentHandler) {
            return PIGMENT;
        }
        if (handler instanceof ISlurryHandler) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical handler type");
    }

    public static ChemicalType getTypeFor(IChemicalTank<?, ?> tank) {
        if (tank instanceof IGasTank) {
            return GAS;
        }
        if (tank instanceof IInfusionTank) {
            return INFUSION;
        }
        if (tank instanceof IPigmentTank) {
            return PIGMENT;
        }
        if (tank instanceof ISlurryTank) {
            return SLURRY;
        }
        throw new IllegalStateException("Unknown chemical tank type");
    }

    static {
        ChemicalType[] values = ChemicalType.values();
        nameToType = new Object2ObjectArrayMap(values.length);
        for (ChemicalType type : values) {
            nameToType.put(type.getSerializedName(), type);
        }
        CODEC = StringRepresentable.fromEnum(ChemicalType::values);
    }
}

