/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.container.ContainerInteraction;
import mekanism.api.container.InContainerGetter;
import mekanism.api.container.LongContainerInteraction;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalUtils {
    public static final Codec<GasStack> GAS_STACK_CODEC = ChemicalStack.codec(Gas.CODEC, "gas", GasStack::new);
    public static final Codec<InfusionStack> INFUSION_STACK_CODEC = ChemicalStack.codec(InfuseType.CODEC, "infuse_type", InfusionStack::new);
    public static final Codec<PigmentStack> PIGMENT_STACK_CODEC = ChemicalStack.codec(Pigment.CODEC, "pigment", PigmentStack::new);
    public static final Codec<SlurryStack> SLURRY_STACK_CODEC = ChemicalStack.codec(Slurry.CODEC, "slurry", SlurryStack::new);

    private ChemicalUtils() {
    }

    public static void writeChemicalStack(FriendlyByteBuf buffer, ChemicalStack<?> stack) {
        if (stack.isEmpty()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            stack.writeToPacket(buffer);
        }
    }

    public static GasStack readGasStack(FriendlyByteBuf buffer) {
        return ChemicalUtils.readStack(buffer, GasStack::readFromPacket, GasStack.EMPTY);
    }

    public static InfusionStack readInfusionStack(FriendlyByteBuf buffer) {
        return ChemicalUtils.readStack(buffer, InfusionStack::readFromPacket, InfusionStack.EMPTY);
    }

    public static PigmentStack readPigmentStack(FriendlyByteBuf buffer) {
        return ChemicalUtils.readStack(buffer, PigmentStack::readFromPacket, PigmentStack.EMPTY);
    }

    public static SlurryStack readSlurryStack(FriendlyByteBuf buffer) {
        return ChemicalUtils.readStack(buffer, SlurryStack::readFromPacket, SlurryStack.EMPTY);
    }

    private static <STACK extends ChemicalStack<?>> STACK readStack(FriendlyByteBuf buffer, FriendlyByteBuf.Reader<STACK> reader, STACK empty) {
        return (STACK)(buffer.readBoolean() ? (ChemicalStack)reader.apply((Object)buffer) : empty);
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>> CHEMICAL readChemicalFromNBT(@Nullable CompoundTag nbtTags, CHEMICAL empty, String nbtName, Function<ResourceLocation, CHEMICAL> registryLookup) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return empty;
        }
        return (CHEMICAL)((Chemical)registryLookup.apply(new ResourceLocation(nbtTags.getString(nbtName))));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>> CHEMICAL readChemicalFromRegistry(@Nullable ResourceLocation name, CHEMICAL empty, Registry<CHEMICAL> registry) {
        if (name == null) {
            return empty;
        }
        Chemical chemical = (Chemical)registry.get(name);
        return (CHEMICAL)Objects.requireNonNullElse(chemical, empty);
    }

    @Deprecated(forRemoval=true, since="10.5.13")
    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK insert(STACK stack, Action action, STACK empty, IntSupplier tankCount, Int2ObjectFunction<@NotNull STACK> inTankGetter, InsertChemical<STACK> insertChemical) {
        if (stack.isEmpty()) {
            return empty;
        }
        return (STACK)ChemicalUtils.insert(stack, null, action, empty, side -> tankCount.getAsInt(), (tank, side) -> (ChemicalStack)inTankGetter.apply(tank), (tank, chemical, side, act) -> insertChemical.insert(tank, chemical, act));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK insert(STACK stack, @Nullable Direction side, Action action, STACK empty, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<STACK> inTankGetter, ContainerInteraction<STACK> insertChemical) {
        ChemicalStack remainder;
        if (stack.isEmpty()) {
            return empty;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return stack;
        }
        if (tanks == 1) {
            return (STACK)((ChemicalStack)insertChemical.interact(0, stack, side, action));
        }
        Object toInsert = stack;
        IntArrayList emptyTanks = new IntArrayList();
        for (int tank = 0; tank < tanks; ++tank) {
            ChemicalStack inTank = (ChemicalStack)inTankGetter.getStored(tank, side);
            if (inTank.isEmpty()) {
                emptyTanks.add(tank);
                continue;
            }
            if (!inTank.isTypeEqual(stack)) continue;
            remainder = (ChemicalStack)insertChemical.interact(tank, toInsert, side, action);
            if (remainder.isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        IntListIterator intListIterator = emptyTanks.iterator();
        while (intListIterator.hasNext()) {
            int tank = (Integer)intListIterator.next();
            remainder = (ChemicalStack)insertChemical.interact(tank, toInsert, side, action);
            if (remainder.isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> STACK insert(STACK stack, @Nullable Direction side, Function<@Nullable Direction, List<TANK>> tankSupplier, Action action, AutomationType automationType, STACK empty) {
        STACK remainder;
        if (stack.isEmpty()) {
            return empty;
        }
        List<TANK> chemicalContainers = tankSupplier.apply(side);
        if (chemicalContainers.isEmpty()) {
            return stack;
        }
        if (chemicalContainers.size() == 1) {
            return ((IChemicalTank)chemicalContainers.get(0)).insert(stack, action, automationType);
        }
        STACK toInsert = stack;
        ArrayList<IChemicalTank> emptyTanks = new ArrayList<IChemicalTank>();
        for (IChemicalTank tank : chemicalContainers) {
            if (tank.isEmpty()) {
                emptyTanks.add(tank);
                continue;
            }
            if (!tank.isTypeEqual(stack)) continue;
            remainder = tank.insert(toInsert, action, automationType);
            if (remainder.isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        for (IChemicalTank tank : emptyTanks) {
            remainder = tank.insert(toInsert, action, automationType);
            if (remainder.isEmpty()) {
                return empty;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    @Deprecated(forRemoval=true, since="10.5.13")
    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(long amount, Action action, STACK empty, IntSupplier tankCount, Int2ObjectFunction<@NotNull STACK> inTankGetter, ExtractChemical<STACK> extractChemical) {
        if (amount == 0L) {
            return empty;
        }
        return (STACK)ChemicalUtils.extract(amount, null, action, empty, (Direction side) -> tankCount.getAsInt(), (int tank, Direction side) -> (ChemicalStack)inTankGetter.apply(tank), (int tank, long chemical, Direction side, Action act) -> extractChemical.extract(tank, chemical, act));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(long amount, @Nullable Direction side, Action action, STACK empty, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<STACK> inTankGetter, LongContainerInteraction<STACK> extractChemical) {
        if (amount == 0L) {
            return empty;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return empty;
        }
        if (tanks == 1) {
            return (STACK)((ChemicalStack)extractChemical.interact(0, amount, side, action));
        }
        Object extracted = empty;
        long toDrain = amount;
        for (int tank = 0; tank < tanks; ++tank) {
            ChemicalStack drained;
            if (!extracted.isEmpty() && !extracted.isTypeEqual((ChemicalStack)((ChemicalStack)inTankGetter.getStored(tank, side))) || (drained = (ChemicalStack)extractChemical.interact(tank, toDrain, side, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0L) break;
        }
        return extracted;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> STACK extract(long amount, @Nullable Direction side, Function<@Nullable Direction, List<TANK>> tankSupplier, Action action, AutomationType automationType, STACK empty) {
        if (amount == 0L) {
            return empty;
        }
        List<TANK> chemicalTanks = tankSupplier.apply(side);
        if (chemicalTanks.isEmpty()) {
            return empty;
        }
        if (chemicalTanks.size() == 1) {
            return ((IChemicalTank)chemicalTanks.get(0)).extract(amount, action, automationType);
        }
        STACK extracted = empty;
        long toDrain = amount;
        for (IChemicalTank tank : chemicalTanks) {
            Object drained;
            if (!extracted.isEmpty() && !tank.isTypeEqual(extracted) || ((ChemicalStack)(drained = tank.extract(toDrain, action, automationType))).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(((ChemicalStack)drained).getAmount());
            }
            if ((toDrain -= ((ChemicalStack)drained).getAmount()) != 0L) continue;
            break;
        }
        return extracted;
    }

    @Deprecated(forRemoval=true, since="10.5.13")
    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(STACK stack, Action action, STACK empty, IntSupplier tankCount, Int2ObjectFunction<@NotNull STACK> inTankGetter, ExtractChemical<STACK> extractChemical) {
        if (stack.isEmpty()) {
            return empty;
        }
        return (STACK)ChemicalUtils.extract(stack, null, action, empty, (Direction side) -> tankCount.getAsInt(), (int tank, Direction side) -> (ChemicalStack)inTankGetter.apply(tank), (int tank, long chemical, Direction side, Action act) -> extractChemical.extract(tank, chemical, act));
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> STACK extract(STACK stack, @Nullable Direction side, Action action, STACK empty, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<STACK> inTankGetter, LongContainerInteraction<STACK> extractChemical) {
        if (stack.isEmpty()) {
            return empty;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return empty;
        }
        if (tanks == 1) {
            ChemicalStack inTank = (ChemicalStack)inTankGetter.getStored(0, side);
            if (inTank.isEmpty() || !inTank.isTypeEqual(stack)) {
                return empty;
            }
            return (STACK)((ChemicalStack)extractChemical.interact(0, stack.getAmount(), side, action));
        }
        Object extracted = empty;
        long toDrain = stack.getAmount();
        for (int tank = 0; tank < tanks; ++tank) {
            ChemicalStack drained;
            if (!stack.isTypeEqual((ChemicalStack)((ChemicalStack)inTankGetter.getStored(tank, side))) || (drained = (ChemicalStack)extractChemical.interact(tank, toDrain, side, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0L) break;
        }
        return extracted;
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, TANK extends IChemicalTank<CHEMICAL, STACK>> STACK extract(STACK stack, @Nullable Direction side, Function<@Nullable Direction, List<TANK>> tankSupplier, Action action, AutomationType automationType, STACK empty) {
        if (stack.isEmpty()) {
            return empty;
        }
        List<TANK> chemicalTanks = tankSupplier.apply(side);
        if (chemicalTanks.isEmpty()) {
            return empty;
        }
        if (chemicalTanks.size() == 1) {
            IChemicalTank tank = (IChemicalTank)chemicalTanks.get(0);
            if (tank.isEmpty() || !tank.isTypeEqual(stack)) {
                return empty;
            }
            return tank.extract(stack.getAmount(), action, automationType);
        }
        STACK extracted = empty;
        long toDrain = stack.getAmount();
        for (IChemicalTank tank : chemicalTanks) {
            Object drained;
            if (!tank.isTypeEqual(stack) || ((ChemicalStack)(drained = tank.extract(toDrain, action, automationType))).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(((ChemicalStack)drained).getAmount());
            }
            if ((toDrain -= ((ChemicalStack)drained).getAmount()) != 0L) continue;
            break;
        }
        return extracted;
    }

    @FunctionalInterface
    @Deprecated(forRemoval=true, since="10.5.13")
    public static interface InsertChemical<STACK extends ChemicalStack<?>> {
        public STACK insert(int var1, STACK var2, Action var3);
    }

    @FunctionalInterface
    @Deprecated(forRemoval=true, since="10.5.13")
    public static interface ExtractChemical<STACK extends ChemicalStack<?>> {
        public STACK extract(int var1, long var2, Action var4);
    }

    @FunctionalInterface
    public static interface StackToStackCreator<STACK extends ChemicalStack<?>> {
        public STACK createStack(STACK var1, long var2);
    }

    @FunctionalInterface
    public static interface ChemicalToStackCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> {
        public STACK createStack(CHEMICAL var1, long var2);
    }
}

