/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical;

import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface ISidedChemicalHandler<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends IChemicalHandler<CHEMICAL, STACK> {
    @Nullable
    default public Direction getSideFor() {
        return null;
    }

    public int getTanks(@Nullable Direction var1);

    @Override
    default public int getTanks() {
        return this.getTanks(this.getSideFor());
    }

    public STACK getChemicalInTank(int var1, @Nullable Direction var2);

    @Override
    default public STACK getChemicalInTank(int tank) {
        return this.getChemicalInTank(tank, this.getSideFor());
    }

    public void setChemicalInTank(int var1, STACK var2, @Nullable Direction var3);

    @Override
    default public void setChemicalInTank(int tank, STACK stack) {
        this.setChemicalInTank(tank, stack, this.getSideFor());
    }

    public long getTankCapacity(int var1, @Nullable Direction var2);

    @Override
    default public long getTankCapacity(int tank) {
        return this.getTankCapacity(tank, this.getSideFor());
    }

    public boolean isValid(int var1, STACK var2, @Nullable Direction var3);

    @Override
    default public boolean isValid(int tank, STACK stack) {
        return this.isValid(tank, stack, this.getSideFor());
    }

    public STACK insertChemical(int var1, STACK var2, @Nullable Direction var3, Action var4);

    @Override
    default public STACK insertChemical(int tank, STACK stack, Action action) {
        return this.insertChemical(tank, stack, this.getSideFor(), action);
    }

    public STACK extractChemical(int var1, long var2, @Nullable Direction var4, Action var5);

    @Override
    default public STACK extractChemical(int tank, long amount, Action action) {
        return this.extractChemical(tank, amount, this.getSideFor(), action);
    }

    default public STACK insertChemical(STACK stack, @Nullable Direction side, Action action) {
        return (STACK)ChemicalUtils.insert(stack, side, action, this.getEmptyStack(), this::getTanks, this::getChemicalInTank, this::insertChemical);
    }

    default public STACK extractChemical(long amount, @Nullable Direction side, Action action) {
        return (STACK)ChemicalUtils.extract(amount, side, action, this.getEmptyStack(), this::getTanks, this::getChemicalInTank, this::extractChemical);
    }

    default public STACK extractChemical(STACK stack, @Nullable Direction side, Action action) {
        return (STACK)ChemicalUtils.extract(stack, side, action, this.getEmptyStack(), this::getTanks, this::getChemicalInTank, this::extractChemical);
    }
}

