/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas;

import com.mojang.serialization.Codec;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasBuilder;
import mekanism.api.providers.IGasProvider;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class Gas
extends Chemical<Gas>
implements IGasProvider {
    public static final Codec<Gas> CODEC = MekanismAPI.GAS_REGISTRY.byNameCodec();

    public Gas(GasBuilder builder) {
        super(builder);
    }

    public static Gas readFromNBT(@Nullable CompoundTag nbtTags) {
        return ChemicalUtils.readChemicalFromNBT(nbtTags, MekanismAPI.EMPTY_GAS, "gasName", Gas::getFromRegistry);
    }

    public static Gas getFromRegistry(@Nullable ResourceLocation name) {
        return ChemicalUtils.readChemicalFromRegistry(name, MekanismAPI.EMPTY_GAS, MekanismAPI.GAS_REGISTRY);
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        nbtTags.putString("gasName", this.getRegistryName().toString());
        return nbtTags;
    }

    public String toString() {
        return "[Gas: " + this.getRegistryName() + "]";
    }

    @Override
    public final boolean isEmptyType() {
        return this == MekanismAPI.EMPTY_GAS;
    }

    @Override
    protected final Registry<Gas> getRegistry() {
        return MekanismAPI.GAS_REGISTRY;
    }

    @Override
    protected String getDefaultTranslationKey() {
        return Util.makeDescriptionId((String)"gas", (ResourceLocation)this.getRegistryName());
    }
}

