/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.gas;

import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.providers.IGasProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class GasStack
extends ChemicalStack<Gas> {
    public static final GasStack EMPTY = new GasStack(MekanismAPI.EMPTY_GAS, 0L);

    public GasStack(IGasProvider gasProvider, long amount) {
        super((Gas)gasProvider.getChemical(), amount);
    }

    public GasStack(Holder<Gas> gasHolder, long amount) {
        this((IGasProvider)gasHolder.value(), amount);
    }

    public GasStack(GasStack stack, long amount) {
        this((IGasProvider)stack.getType(), amount);
    }

    @Override
    protected Registry<Gas> getRegistry() {
        return MekanismAPI.GAS_REGISTRY;
    }

    @Override
    protected Gas getEmptyChemical() {
        return MekanismAPI.EMPTY_GAS;
    }

    public static GasStack readFromNBT(@Nullable CompoundTag nbtTags) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return EMPTY;
        }
        Gas type = Gas.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.getLong("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new GasStack(type, amount);
    }

    public static GasStack readFromPacket(FriendlyByteBuf buf) {
        Gas gas = (Gas)buf.readById(MekanismAPI.GAS_REGISTRY);
        if (gas == null || gas.isEmptyType()) {
            return EMPTY;
        }
        return new GasStack(gas, buf.readVarLong());
    }

    public GasStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new GasStack(this, this.getAmount());
    }
}

