/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.infuse;

import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.providers.IInfuseTypeProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class InfusionStack
extends ChemicalStack<InfuseType> {
    public static final InfusionStack EMPTY = new InfusionStack(MekanismAPI.EMPTY_INFUSE_TYPE, 0L);

    public InfusionStack(IInfuseTypeProvider infuseTypeProvider, long amount) {
        super((InfuseType)infuseTypeProvider.getChemical(), amount);
    }

    public InfusionStack(Holder<InfuseType> infuseTypeHolder, long amount) {
        this((IInfuseTypeProvider)infuseTypeHolder.value(), amount);
    }

    public InfusionStack(InfusionStack stack, long amount) {
        this((IInfuseTypeProvider)stack.getType(), amount);
    }

    @Override
    protected Registry<InfuseType> getRegistry() {
        return MekanismAPI.INFUSE_TYPE_REGISTRY;
    }

    @Override
    protected InfuseType getEmptyChemical() {
        return MekanismAPI.EMPTY_INFUSE_TYPE;
    }

    public static InfusionStack readFromNBT(@Nullable CompoundTag nbtTags) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return EMPTY;
        }
        InfuseType type = InfuseType.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.getLong("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new InfusionStack(type, amount);
    }

    public static InfusionStack readFromPacket(FriendlyByteBuf buf) {
        InfuseType infuseType = (InfuseType)buf.readById(MekanismAPI.INFUSE_TYPE_REGISTRY);
        if (infuseType == null || infuseType.isEmptyType()) {
            return EMPTY;
        }
        return new InfusionStack(infuseType, buf.readVarLong());
    }

    public InfusionStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new InfusionStack(this, this.getAmount());
    }
}

