/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.merged;

import java.util.Objects;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.text.IHasTextComponent;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BoxedChemical
implements IHasTextComponent {
    public static final BoxedChemical EMPTY = new BoxedChemical(ChemicalType.GAS, MekanismAPI.EMPTY_GAS);
    private final ChemicalType chemicalType;
    private final Chemical<?> chemical;

    public static BoxedChemical box(Chemical<?> chemical) {
        if (chemical.isEmptyType()) {
            return EMPTY;
        }
        return new BoxedChemical(ChemicalType.getTypeFor(chemical), chemical);
    }

    public static BoxedChemical read(FriendlyByteBuf buffer) {
        Chemical c;
        ChemicalType chemicalType = (ChemicalType)buffer.readEnum(ChemicalType.class);
        switch (chemicalType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case GAS: {
                Chemical chemical = (Gas)buffer.readById(MekanismAPI.GAS_REGISTRY);
                break;
            }
            case INFUSION: {
                Chemical chemical = (InfuseType)buffer.readById(MekanismAPI.INFUSE_TYPE_REGISTRY);
                break;
            }
            case PIGMENT: {
                Chemical chemical = (Pigment)buffer.readById(MekanismAPI.PIGMENT_REGISTRY);
                break;
            }
            case SLURRY: {
                Chemical chemical = c = (Slurry)buffer.readById(MekanismAPI.SLURRY_REGISTRY);
            }
        }
        if (c == null || c.isEmptyType()) {
            return EMPTY;
        }
        return new BoxedChemical(chemicalType, c);
    }

    public static BoxedChemical read(@Nullable CompoundTag nbt) {
        ChemicalType chemicalType = ChemicalType.fromNBT(nbt);
        if (chemicalType == null) {
            return EMPTY;
        }
        return new BoxedChemical(chemicalType, switch (chemicalType) {
            default -> throw new IncompatibleClassChangeError();
            case ChemicalType.GAS -> Gas.readFromNBT(nbt);
            case ChemicalType.INFUSION -> InfuseType.readFromNBT(nbt);
            case ChemicalType.PIGMENT -> Pigment.readFromNBT(nbt);
            case ChemicalType.SLURRY -> Slurry.readFromNBT(nbt);
        });
    }

    protected BoxedChemical(ChemicalType chemicalType, Chemical<?> chemical) {
        this.chemicalType = chemicalType;
        this.chemical = chemical;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.chemical.isEmptyType();
    }

    public ChemicalType getChemicalType() {
        return this.chemicalType;
    }

    public CompoundTag write(CompoundTag nbt) {
        this.chemicalType.write(nbt);
        this.chemical.write(nbt);
        return nbt;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.chemicalType);
        switch (this.chemicalType) {
            case GAS: {
                buffer.writeId(MekanismAPI.GAS_REGISTRY, (Object)((Gas)this.chemical));
                break;
            }
            case INFUSION: {
                buffer.writeId(MekanismAPI.INFUSE_TYPE_REGISTRY, (Object)((InfuseType)this.chemical));
                break;
            }
            case PIGMENT: {
                buffer.writeId(MekanismAPI.PIGMENT_REGISTRY, (Object)((Pigment)this.chemical));
                break;
            }
            case SLURRY: {
                buffer.writeId(MekanismAPI.SLURRY_REGISTRY, (Object)((Slurry)this.chemical));
            }
        }
    }

    public Chemical<?> getChemical() {
        return this.chemical;
    }

    @Override
    public Component getTextComponent() {
        return this.chemical.getTextComponent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxedChemical other = (BoxedChemical)o;
        return this.chemicalType == other.chemicalType && this.chemical == other.chemical;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.chemicalType, this.chemical});
    }
}

