/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.pigment;

import com.mojang.serialization.Codec;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.pigment.PigmentBuilder;
import mekanism.api.providers.IPigmentProvider;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class Pigment
extends Chemical<Pigment>
implements IPigmentProvider {
    public static final Codec<Pigment> CODEC = MekanismAPI.PIGMENT_REGISTRY.byNameCodec();

    public Pigment(PigmentBuilder builder) {
        super(builder);
    }

    public static Pigment readFromNBT(@Nullable CompoundTag nbtTags) {
        return ChemicalUtils.readChemicalFromNBT(nbtTags, MekanismAPI.EMPTY_PIGMENT, "pigmentName", Pigment::getFromRegistry);
    }

    public static Pigment getFromRegistry(@Nullable ResourceLocation name) {
        return ChemicalUtils.readChemicalFromRegistry(name, MekanismAPI.EMPTY_PIGMENT, MekanismAPI.PIGMENT_REGISTRY);
    }

    public String toString() {
        return "[Pigment: " + this.getRegistryName() + "]";
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        nbtTags.putString("pigmentName", this.getRegistryName().toString());
        return nbtTags;
    }

    @Override
    public final boolean isEmptyType() {
        return this == MekanismAPI.EMPTY_PIGMENT;
    }

    @Override
    protected final Registry<Pigment> getRegistry() {
        return MekanismAPI.PIGMENT_REGISTRY;
    }

    @Override
    protected String getDefaultTranslationKey() {
        return Util.makeDescriptionId((String)"pigment", (ResourceLocation)this.getRegistryName());
    }
}

