/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.pigment;

import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.providers.IPigmentProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class PigmentStack
extends ChemicalStack<Pigment> {
    public static final PigmentStack EMPTY = new PigmentStack(MekanismAPI.EMPTY_PIGMENT, 0L);

    public PigmentStack(IPigmentProvider pigmentProvider, long amount) {
        super((Pigment)pigmentProvider.getChemical(), amount);
    }

    public PigmentStack(Holder<Pigment> pigmentHolder, long amount) {
        this((IPigmentProvider)pigmentHolder.value(), amount);
    }

    public PigmentStack(PigmentStack stack, long amount) {
        this((IPigmentProvider)stack.getType(), amount);
    }

    @Override
    protected Registry<Pigment> getRegistry() {
        return MekanismAPI.PIGMENT_REGISTRY;
    }

    @Override
    protected Pigment getEmptyChemical() {
        return MekanismAPI.EMPTY_PIGMENT;
    }

    public static PigmentStack readFromNBT(@Nullable CompoundTag nbtTags) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return EMPTY;
        }
        Pigment type = Pigment.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.getLong("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new PigmentStack(type, amount);
    }

    public static PigmentStack readFromPacket(FriendlyByteBuf buf) {
        Pigment pigment = (Pigment)buf.readById(MekanismAPI.PIGMENT_REGISTRY);
        if (pigment == null || pigment.isEmptyType()) {
            return EMPTY;
        }
        return new PigmentStack(pigment, buf.readVarLong());
    }

    public PigmentStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new PigmentStack(this, this.getAmount());
    }
}

