/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.slurry;

import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.providers.ISlurryProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class SlurryStack
extends ChemicalStack<Slurry> {
    public static final SlurryStack EMPTY = new SlurryStack(MekanismAPI.EMPTY_SLURRY, 0L);

    public SlurryStack(ISlurryProvider slurryProvider, long amount) {
        super((Slurry)slurryProvider.getChemical(), amount);
    }

    public SlurryStack(Holder<Slurry> slurryHolder, long amount) {
        this((ISlurryProvider)slurryHolder.value(), amount);
    }

    public SlurryStack(SlurryStack stack, long amount) {
        this((ISlurryProvider)stack.getType(), amount);
    }

    @Override
    protected Registry<Slurry> getRegistry() {
        return MekanismAPI.SLURRY_REGISTRY;
    }

    @Override
    protected Slurry getEmptyChemical() {
        return MekanismAPI.EMPTY_SLURRY;
    }

    public static SlurryStack readFromNBT(@Nullable CompoundTag nbtTags) {
        if (nbtTags == null || nbtTags.isEmpty()) {
            return EMPTY;
        }
        Slurry type = Slurry.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.getLong("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new SlurryStack(type, amount);
    }

    public static SlurryStack readFromPacket(FriendlyByteBuf buf) {
        Slurry slurry = (Slurry)buf.readById(MekanismAPI.SLURRY_REGISTRY);
        if (slurry == null || slurry.isEmptyType()) {
            return EMPTY;
        }
        return new SlurryStack(slurry, buf.readVarLong());
    }

    public SlurryStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new SlurryStack(this, this.getAmount());
    }
}

