/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.basic.BasicCompressingRecipe;
import mekanism.api.recipes.basic.BasicInjectingRecipe;
import mekanism.api.recipes.basic.BasicMetallurgicInfuserRecipe;
import mekanism.api.recipes.basic.BasicPaintingRecipe;
import mekanism.api.recipes.basic.BasicPurifyingRecipe;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@NothingNullByDefault
public class ItemStackChemicalToItemStackRecipeBuilder<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipeBuilder<ItemStackChemicalToItemStackRecipeBuilder<CHEMICAL, STACK, INGREDIENT>> {
    private final Factory<CHEMICAL, STACK, INGREDIENT> factory;
    private final ItemStackIngredient itemInput;
    private final INGREDIENT chemicalInput;
    private final ItemStack output;

    protected ItemStackChemicalToItemStackRecipeBuilder(ItemStackIngredient itemInput, INGREDIENT chemicalInput, ItemStack output, Factory<CHEMICAL, STACK, INGREDIENT> factory) {
        this.itemInput = itemInput;
        this.chemicalInput = chemicalInput;
        this.output = output;
        this.factory = factory;
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> compressing(ItemStackIngredient itemInput, ChemicalStackIngredient.GasStackIngredient gasInput, ItemStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This compressing recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>(itemInput, gasInput, output, BasicCompressingRecipe::new);
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> purifying(ItemStackIngredient itemInput, ChemicalStackIngredient.GasStackIngredient gasInput, ItemStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This purifying recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>(itemInput, gasInput, output, BasicPurifyingRecipe::new);
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> injecting(ItemStackIngredient itemInput, ChemicalStackIngredient.GasStackIngredient gasInput, ItemStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This injecting recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>(itemInput, gasInput, output, BasicInjectingRecipe::new);
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient> metallurgicInfusing(ItemStackIngredient itemInput, ChemicalStackIngredient.InfusionStackIngredient infusionInput, ItemStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This metallurgic infusing recipe requires a non empty output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient>(itemInput, infusionInput, output, BasicMetallurgicInfuserRecipe::new);
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient> painting(ItemStackIngredient itemInput, ChemicalStackIngredient.PigmentStackIngredient pigmentInput, ItemStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This painting recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient>(itemInput, pigmentInput, output, BasicPaintingRecipe::new);
    }

    protected ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT> asRecipe() {
        return this.factory.create(this.itemInput, this.chemicalInput, this.output);
    }

    public void build(RecipeOutput recipeOutput) {
        this.build(recipeOutput, (ItemLike)this.output.getItem());
    }

    @FunctionalInterface
    public static interface Factory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>> {
        public ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT> create(ItemStackIngredient var1, INGREDIENT var2, ItemStack var3);
    }
}

