/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.fluid;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.container.ContainerInteraction;
import mekanism.api.container.InContainerGetter;
import mekanism.api.container.IntContainerInteraction;
import mekanism.api.fluid.IExtendedFluidTank;
import net.minecraft.core.Direction;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedFluidHandlerUtils {
    @Deprecated(forRemoval=true, since="10.5.13")
    public static FluidStack insert(FluidStack stack, Action action, IntSupplier tankCount, Int2ObjectFunction<@NotNull FluidStack> inTankGetter, InsertFluid insertFluid) {
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return ExtendedFluidHandlerUtils.insert(stack, null, action, side -> tankCount.getAsInt(), (tank, side) -> (FluidStack)inTankGetter.apply(tank), (tank, fluid, side, act) -> insertFluid.insert(tank, (FluidStack)fluid, act));
    }

    public static FluidStack insert(FluidStack stack, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<FluidStack> inTankGetter, ContainerInteraction<FluidStack> insertFluid) {
        FluidStack remainder;
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return stack;
        }
        if (tanks == 1) {
            return insertFluid.interact(0, stack, side, action);
        }
        FluidStack toInsert = stack;
        IntArrayList emptyTanks = new IntArrayList();
        for (int tank = 0; tank < tanks; ++tank) {
            FluidStack inTank = inTankGetter.getStored(tank, side);
            if (inTank.isEmpty()) {
                emptyTanks.add(tank);
                continue;
            }
            if (!inTank.isFluidEqual(stack)) continue;
            remainder = insertFluid.interact(tank, toInsert, side, action);
            if (remainder.isEmpty()) {
                return FluidStack.EMPTY;
            }
            toInsert = remainder;
        }
        IntListIterator intListIterator = emptyTanks.iterator();
        while (intListIterator.hasNext()) {
            int tank = (Integer)intListIterator.next();
            remainder = insertFluid.interact(tank, toInsert, side, action);
            if (remainder.isEmpty()) {
                return FluidStack.EMPTY;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static FluidStack insert(FluidStack stack, @Nullable Direction side, Function<@Nullable Direction, List<IExtendedFluidTank>> fluidTankSupplier, Action action, AutomationType automationType) {
        FluidStack remainder;
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        List<IExtendedFluidTank> fluidContainers = fluidTankSupplier.apply(side);
        if (fluidContainers.isEmpty()) {
            return stack;
        }
        if (fluidContainers.size() == 1) {
            return fluidContainers.get(0).insert(stack, action, automationType);
        }
        FluidStack toInsert = stack;
        ArrayList<IExtendedFluidTank> emptyTanks = new ArrayList<IExtendedFluidTank>();
        for (IExtendedFluidTank tank : fluidContainers) {
            if (tank.isEmpty()) {
                emptyTanks.add(tank);
                continue;
            }
            if (!tank.isFluidEqual(stack)) continue;
            remainder = tank.insert(toInsert, action, automationType);
            if (remainder.isEmpty()) {
                return FluidStack.EMPTY;
            }
            toInsert = remainder;
        }
        for (IExtendedFluidTank tank : emptyTanks) {
            remainder = tank.insert(toInsert, action, automationType);
            if (remainder.isEmpty()) {
                return FluidStack.EMPTY;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    @Deprecated(forRemoval=true, since="10.5.13")
    public static FluidStack extract(int amount, Action action, IntSupplier tankCount, Int2ObjectFunction<@NotNull FluidStack> inTankGetter, ExtractFluid extractFluid) {
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        return ExtendedFluidHandlerUtils.extract(amount, null, action, (Direction side) -> tankCount.getAsInt(), (int tank, Direction side) -> (FluidStack)inTankGetter.apply(tank), (int tank, int fluid, Direction side, Action act) -> extractFluid.extract(tank, fluid, act));
    }

    public static FluidStack extract(int amount, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<FluidStack> inTankGetter, IntContainerInteraction<FluidStack> extractFluid) {
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return FluidStack.EMPTY;
        }
        if (tanks == 1) {
            return extractFluid.interact(0, amount, side, action);
        }
        FluidStack extracted = FluidStack.EMPTY;
        int toDrain = amount;
        for (int tank = 0; tank < tanks; ++tank) {
            FluidStack drained;
            if (!extracted.isEmpty() && !extracted.isFluidEqual(inTankGetter.getStored(tank, side)) || (drained = extractFluid.interact(tank, toDrain, side, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0) break;
        }
        return extracted;
    }

    public static FluidStack extract(int amount, @Nullable Direction side, Function<@Nullable Direction, List<IExtendedFluidTank>> fluidTankSupplier, Action action, AutomationType automationType) {
        if (amount == 0) {
            return FluidStack.EMPTY;
        }
        List<IExtendedFluidTank> fluidContainers = fluidTankSupplier.apply(side);
        if (fluidContainers.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (fluidContainers.size() == 1) {
            return fluidContainers.get(0).extract(amount, action, automationType);
        }
        FluidStack extracted = FluidStack.EMPTY;
        int toDrain = amount;
        for (IExtendedFluidTank fluidTank : fluidContainers) {
            FluidStack drained;
            if (!extracted.isEmpty() && !fluidTank.isFluidEqual(extracted) || (drained = fluidTank.extract(toDrain, action, automationType)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) != 0) continue;
            break;
        }
        return extracted;
    }

    @Deprecated(forRemoval=true, since="10.5.13")
    public static FluidStack extract(FluidStack stack, Action action, IntSupplier tankCount, Int2ObjectFunction<@NotNull FluidStack> inTankGetter, ExtractFluid extractFluid) {
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return ExtendedFluidHandlerUtils.extract(stack, null, action, (Direction side) -> tankCount.getAsInt(), (int tank, Direction side) -> (FluidStack)inTankGetter.apply(tank), (int tank, int fluid, Direction side, Action act) -> extractFluid.extract(tank, fluid, act));
    }

    public static FluidStack extract(FluidStack stack, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> tankCount, InContainerGetter<FluidStack> inTankGetter, IntContainerInteraction<FluidStack> extractFluid) {
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int tanks = tankCount.applyAsInt(side);
        if (tanks == 0) {
            return FluidStack.EMPTY;
        }
        if (tanks == 1) {
            FluidStack inTank = inTankGetter.getStored(0, side);
            if (inTank.isEmpty() || !inTank.isFluidEqual(stack)) {
                return FluidStack.EMPTY;
            }
            return extractFluid.interact(0, stack.getAmount(), side, action);
        }
        FluidStack extracted = FluidStack.EMPTY;
        int toDrain = stack.getAmount();
        for (int tank = 0; tank < tanks; ++tank) {
            FluidStack drained;
            if (!stack.isFluidEqual(inTankGetter.getStored(tank, side)) || (drained = extractFluid.interact(tank, toDrain, side, action)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) == 0) break;
        }
        return extracted;
    }

    public static FluidStack extract(FluidStack stack, @Nullable Direction side, Function<@Nullable Direction, List<IExtendedFluidTank>> fluidTankSupplier, Action action, AutomationType automationType) {
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        List<IExtendedFluidTank> fluidContainers = fluidTankSupplier.apply(side);
        if (fluidContainers.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (fluidContainers.size() == 1) {
            IExtendedFluidTank tank = fluidContainers.get(0);
            if (tank.isEmpty() || !tank.isFluidEqual(stack)) {
                return FluidStack.EMPTY;
            }
            return tank.extract(stack.getAmount(), action, automationType);
        }
        FluidStack extracted = FluidStack.EMPTY;
        int toDrain = stack.getAmount();
        for (IExtendedFluidTank fluidTank : fluidContainers) {
            FluidStack drained;
            if (!fluidTank.isFluidEqual(stack) || (drained = fluidTank.extract(toDrain, action, automationType)).isEmpty()) continue;
            if (extracted.isEmpty()) {
                extracted = drained;
            } else {
                extracted.grow(drained.getAmount());
            }
            if ((toDrain -= drained.getAmount()) != 0) continue;
            break;
        }
        return extracted;
    }

    @FunctionalInterface
    @Deprecated(forRemoval=true, since="10.5.13")
    public static interface InsertFluid {
        public FluidStack insert(int var1, FluidStack var2, Action var3);
    }

    @FunctionalInterface
    @Deprecated(forRemoval=true, since="10.5.13")
    public static interface ExtractFluid {
        public FluidStack extract(int var1, int var2, Action var3);
    }
}

