/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import net.minecraft.world.item.enchantment.Enchantment;

@NothingNullByDefault
public abstract class EnchantmentBasedModule<MODULE extends EnchantmentBasedModule<MODULE>>
implements ICustomModule<MODULE> {
    public abstract Enchantment getEnchantment();

    @Override
    public void onAdded(IModule<MODULE> module, boolean first) {
        this.updateEnchantment(module);
    }

    @Override
    public void onRemoved(IModule<MODULE> module, boolean last) {
        this.updateEnchantment(module);
    }

    @Override
    public void onEnabledStateChange(IModule<MODULE> module) {
        if (module.isEnabled()) {
            this.updateEnchantment(module);
        } else {
            module.getContainer().setEnchantmentLevel(this.getEnchantment(), 0);
        }
    }

    private void updateEnchantment(IModule<MODULE> module) {
        if (module.isEnabled()) {
            module.getContainer().setEnchantmentLevel(this.getEnchantment(), module.getInstalledCount());
        }
    }
}

