/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.Objects;
import java.util.function.Consumer;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.radial.mode.NestedRadialMode;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.neoforged.neoforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface ICustomModule<MODULE extends ICustomModule<MODULE>> {
    default public void init(IModule<MODULE> module, ModuleConfigItemCreator configItemCreator) {
    }

    default public void tickServer(IModule<MODULE> module, Player player) {
    }

    default public void tickClient(IModule<MODULE> module, Player player) {
    }

    default public void addHUDStrings(IModule<MODULE> module, Player player, Consumer<Component> hudStringAdder) {
    }

    default public void addHUDElements(IModule<MODULE> module, Player player, Consumer<IHUDElement> hudElementAdder) {
    }

    default public boolean canChangeModeWhenDisabled(IModule<MODULE> module) {
        return false;
    }

    default public boolean canChangeRadialModeWhenDisabled(IModule<MODULE> module) {
        return false;
    }

    @Nullable
    default public Component getModeScrollComponent(IModule<MODULE> module, ItemStack stack) {
        return null;
    }

    default public void changeMode(IModule<MODULE> module, Player player, ItemStack stack, int shift, boolean displayChangeMessage) {
    }

    default public void addRadialModes(IModule<MODULE> module, ItemStack stack, Consumer<NestedRadialMode> adder) {
    }

    @Nullable
    default public <MODE extends IRadialMode> MODE getMode(IModule<MODULE> module, ItemStack stack, RadialData<MODE> radialData) {
        return null;
    }

    default public <MODE extends IRadialMode> boolean setMode(IModule<MODULE> module, Player player, ItemStack stack, RadialData<MODE> radialData, MODE mode) {
        return false;
    }

    default public void onAdded(IModule<MODULE> module, boolean first) {
    }

    default public void onRemoved(IModule<MODULE> module, boolean last) {
    }

    default public void onEnabledStateChange(IModule<MODULE> module) {
    }

    @Nullable
    default public ModuleDamageAbsorbInfo getDamageAbsorbInfo(IModule<MODULE> module, DamageSource damageSource) {
        return null;
    }

    default public InteractionResult onItemUse(IModule<MODULE> module, UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public boolean canPerformAction(IModule<MODULE> module, ToolAction action) {
        return false;
    }

    default public InteractionResult onInteract(IModule<MODULE> module, Player player, LivingEntity entity, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    default public ModuleDispenseResult onDispense(IModule<MODULE> module, BlockSource source) {
        return ModuleDispenseResult.DEFAULT;
    }

    public static enum ModuleDispenseResult {
        HANDLED,
        DEFAULT,
        FAIL_PREVENT_DROP;

    }

    public record ModuleDamageAbsorbInfo(@NotNull FloatSupplier absorptionRatio, @NotNull FloatingLongSupplier energyCost) {
        public ModuleDamageAbsorbInfo(@NotNull FloatSupplier absorptionRatio, @NotNull FloatingLongSupplier energyCost) {
            Objects.requireNonNull(absorptionRatio, "Absorption ratio supplier cannot be null");
            Objects.requireNonNull(energyCost, "Energy cost supplier cannot be null");
        }
    }
}

