/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@NothingNullByDefault
public interface IModuleContainer
extends INBTSerializable<CompoundTag> {
    public Map<ModuleData<?>, ? extends IModule<?>> typedModules();

    public Collection<? extends IModule<?>> modules();

    default public Set<ModuleData<?>> moduleTypes() {
        return this.typedModules().keySet();
    }

    public Map<Enchantment, Integer> moduleBasedEnchantments();

    default public int getModuleEnchantmentLevel(Enchantment enchantment) {
        return this.moduleBasedEnchantments().getOrDefault(enchantment, 0);
    }

    @ApiStatus.Internal
    public void setEnchantmentLevel(Enchantment var1, int var2);

    public ItemStack getPreviewStack();

    @Nullable
    public <T, C> T getCapabilityFromStack(ItemCapability<T, C> var1, @UnknownNullability C var2);

    @Nullable
    default public <T> T getCapabilityFromStack(ItemCapability<T, Void> capability) {
        return this.getCapabilityFromStack(capability, null);
    }

    default public int installedCount() {
        return this.typedModules().size();
    }

    default public int installedCount(IModuleDataProvider<?> typeProvider) {
        IModule<?> module = this.get(typeProvider);
        return module == null ? 0 : module.getInstalledCount();
    }

    public boolean isContainerOnCooldown(Player var1);

    public boolean isInstance(Class<?> var1);

    @Nullable
    public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> get(IModuleDataProvider<MODULE> var1);

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(IModuleDataProvider<MODULE> typeProvider) {
        IModule<MODULE> module = this.get(typeProvider);
        return module != null && module.isEnabled() ? module : null;
    }

    public boolean has(IModuleDataProvider<?> var1);

    default public boolean hasEnabled(IModuleDataProvider<?> typeProvider) {
        return this.getIfEnabled(typeProvider) != null;
    }

    public Set<ModuleData<?>> supportedTypes();

    default public boolean supports(IModuleDataProvider<?> typeProvider) {
        return this.supportedTypes().contains(typeProvider.getModuleData());
    }

    public List<IHUDElement> getHUDElements(Player var1);

    public List<Component> getHUDStrings(Player var1);

    public boolean isCompatible(IModuleContainer var1);
}

