/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.ModuleData;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IModuleHelper {
    public static final IModuleHelper INSTANCE = ServiceLoader.load(IModuleHelper.class).findFirst().orElseThrow(() -> new IllegalStateException("No valid ServiceImpl for IModuleHelper found"));

    public Item createModuleItem(IModuleDataProvider<?> var1, Item.Properties var2);

    public void dropModuleContainerContents(ItemEntity var1, DamageSource var2);

    public Set<ModuleData<?>> getSupported(Item var1);

    public Set<Item> getSupported(IModuleDataProvider<?> var1);

    public Set<ModuleData<?>> getConflicting(IModuleDataProvider<?> var1);

    default public boolean isEnabled(ItemStack stack, IModuleDataProvider<?> typeProvider) {
        IModuleContainer container = this.getModuleContainerNullable(stack);
        return container != null && container.hasEnabled(typeProvider);
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> load(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        IModuleContainer container = this.getModuleContainerNullable(stack);
        return container == null ? null : container.get(typeProvider);
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(ItemStack stack, IModuleDataProvider<MODULE> typeProvider) {
        IModuleContainer container = this.getModuleContainerNullable(stack);
        return container == null ? null : container.getIfEnabled(typeProvider);
    }

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(@Nullable LivingEntity entity, @Nullable EquipmentSlot slot, IModuleDataProvider<MODULE> typeProvider) {
        IModuleContainer container = this.getModuleContainerNullable(entity, slot);
        return container == null ? null : container.getIfEnabled(typeProvider);
    }

    @Deprecated(forRemoval=true, since="10.5.15")
    default public Optional<? extends IModuleContainer> getModuleContainer(ItemStack stack) {
        return Optional.ofNullable(this.getModuleContainerNullable(stack));
    }

    @Nullable
    public IModuleContainer getModuleContainerNullable(ItemStack var1);

    @Deprecated(forRemoval=true, since="10.5.15")
    default public Optional<? extends IModuleContainer> getModuleContainer(@Nullable LivingEntity entity, @Nullable EquipmentSlot slot) {
        return Optional.ofNullable(this.getModuleContainerNullable(entity, slot));
    }

    @Nullable
    default public IModuleContainer getModuleContainerNullable(@Nullable LivingEntity entity, @Nullable EquipmentSlot slot) {
        if (entity == null || slot == null) {
            return null;
        }
        return this.getModuleContainerNullable(entity.getItemBySlot(slot));
    }

    default public boolean isModuleContainer(ItemStack stack) {
        return !stack.isEmpty() && this.isModuleContainer(stack.getItem());
    }

    public boolean isModuleContainer(Item var1);

    default public Collection<? extends IModule<?>> loadAll(ItemStack stack) {
        IModuleContainer container = this.getModuleContainerNullable(stack);
        return container != null ? container.modules() : Collections.emptyList();
    }

    default public <MODULE extends ICustomModule<?>> List<? extends IModule<? extends MODULE>> loadAll(ItemStack stack, Class<MODULE> moduleClass) {
        ArrayList list = new ArrayList();
        for (IModule<?> module : this.loadAll(stack)) {
            if (!moduleClass.isInstance(module.getCustomInstance())) continue;
            list.add(module);
        }
        return list;
    }

    default public Set<ModuleData<?>> loadAllTypes(ItemStack stack) {
        IModuleContainer container = this.getModuleContainerNullable(stack);
        return container != null ? container.moduleTypes() : Collections.emptySet();
    }

    public IHUDElement hudElement(ResourceLocation var1, Component var2, IHUDElement.HUDColor var3);

    public IHUDElement hudElementEnabled(ResourceLocation var1, boolean var2);

    public IHUDElement hudElementPercent(ResourceLocation var1, double var2);

    public void addMekaSuitModuleModels(ResourceLocation var1);

    default public void addMekaSuitModuleModelSpec(String name, IModuleDataProvider<?> moduleDataProvider, EquipmentSlot slotType) {
        this.addMekaSuitModuleModelSpec(name, moduleDataProvider, slotType, ConstantPredicates.alwaysTrue());
    }

    public void addMekaSuitModuleModelSpec(String var1, IModuleDataProvider<?> var2, EquipmentSlot var3, Predicate<LivingEntity> var4);
}

