/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear.config;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.config.ModuleConfigData;
import net.minecraft.nbt.CompoundTag;

@NothingNullByDefault
public final class ModuleBooleanData
implements ModuleConfigData<Boolean> {
    private boolean value;

    public ModuleBooleanData() {
        this(true);
    }

    public ModuleBooleanData(boolean def) {
        this.value = def;
    }

    @Override
    public Boolean get() {
        return this.value;
    }

    @Override
    public void set(Boolean val) {
        this.value = Objects.requireNonNull(val, "Value cannot be null.");
    }

    @Override
    public void read(String name, CompoundTag tag) {
        Objects.requireNonNull(tag, "Tag cannot be null.");
        Objects.requireNonNull(name, "Name cannot be null.");
        this.value = tag.getBoolean(name);
    }

    @Override
    public void write(String name, CompoundTag tag) {
        Objects.requireNonNull(tag, "Tag cannot be null.");
        Objects.requireNonNull(name, "Name cannot be null.");
        tag.putBoolean(name, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.value == ((ModuleBooleanData)o).value;
    }

    public int hashCode() {
        return Boolean.hashCode(this.value);
    }
}

