/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear.config;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.config.ModuleIntegerData;

@NothingNullByDefault
public final class ModuleColorData
extends ModuleIntegerData {
    private final boolean handlesAlpha;

    public static ModuleColorData argb() {
        return ModuleColorData.argb(-1);
    }

    public static ModuleColorData argb(int defaultColor) {
        return new ModuleColorData(defaultColor, true);
    }

    public static ModuleColorData rgb() {
        return ModuleColorData.rgb(-1);
    }

    public static ModuleColorData rgb(int defaultColor) {
        return new ModuleColorData(defaultColor, false);
    }

    private ModuleColorData(int defaultColor, boolean handlesAlpha) {
        super(handlesAlpha ? defaultColor : defaultColor | 0xFF000000);
        this.handlesAlpha = handlesAlpha;
    }

    @Override
    protected int sanitizeValue(int value) {
        return this.handlesAlpha ? value : value | 0xFF000000;
    }

    public boolean handlesAlpha() {
        return this.handlesAlpha;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return super.equals(o) && this.handlesAlpha == ((ModuleColorData)o).handlesAlpha;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.handlesAlpha);
    }
}

