/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear.config;

import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.config.ModuleConfigData;
import net.minecraft.nbt.CompoundTag;

@NothingNullByDefault
public final class ModuleEnumData<TYPE extends Enum<TYPE>>
implements ModuleConfigData<TYPE> {
    private final List<TYPE> enumConstants;
    private final TYPE defaultValue;
    private TYPE value;

    public ModuleEnumData(TYPE def) {
        this.defaultValue = (Enum)Objects.requireNonNull(def, "Default value cannot be null.");
        this.value = this.defaultValue;
        this.enumConstants = List.of((Enum[])((Enum)this.defaultValue).getDeclaringClass().getEnumConstants());
    }

    public ModuleEnumData(TYPE def, int selectableCount) {
        this.defaultValue = (Enum)Objects.requireNonNull(def, "Default value cannot be null.");
        this.value = this.defaultValue;
        if (selectableCount <= 0) {
            throw new IllegalArgumentException("Invalid selectableCount, there must be at least one element that is selectable.");
        }
        Class enumClass = ((Enum)this.defaultValue).getDeclaringClass();
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        if (constants.length < selectableCount) {
            throw new IllegalArgumentException("Selectable count is larger than the number of elements in " + enumClass.getSimpleName());
        }
        if (constants.length == selectableCount) {
            this.enumConstants = List.of(constants);
        } else {
            if (((Enum)this.defaultValue).ordinal() >= selectableCount) {
                throw new IllegalArgumentException("Invalid default, it is out of range of the selectable values.");
            }
            this.enumConstants = List.of(constants).subList(0, selectableCount);
        }
    }

    @Deprecated(forRemoval=true, since="10.3.2")
    public ModuleEnumData(Class<TYPE> enumClass, TYPE def) {
        this(def);
        Objects.requireNonNull(enumClass, "Enum Class cannot be null.");
    }

    @Deprecated(forRemoval=true, since="10.3.2")
    public ModuleEnumData(Class<TYPE> enumClass, int selectableCount, TYPE def) {
        this(def, selectableCount);
        Objects.requireNonNull(enumClass, "Enum Class cannot be null.");
    }

    public List<TYPE> getEnums() {
        return this.enumConstants;
    }

    @Override
    public TYPE get() {
        return this.value;
    }

    @Override
    public void set(TYPE val) {
        Objects.requireNonNull(val, "Value cannot be null.");
        if (((Enum)val).ordinal() >= this.enumConstants.size()) {
            throw new IllegalArgumentException("Invalid value, it is out of range of the selectable values.");
        }
        this.value = val;
    }

    @Override
    public void read(String name, CompoundTag tag) {
        Objects.requireNonNull(tag, "Tag cannot be null.");
        Objects.requireNonNull(name, "Name cannot be null.");
        int ordinal = tag.getInt(name);
        this.value = ordinal >= 0 && ordinal < this.enumConstants.size() ? (Enum)this.enumConstants.get(ordinal) : this.defaultValue;
    }

    @Override
    public void write(String name, CompoundTag tag) {
        Objects.requireNonNull(tag, "Tag cannot be null.");
        Objects.requireNonNull(name, "Name cannot be null.");
        tag.putInt(name, ((Enum)this.value).ordinal());
    }

    @Override
    public boolean isCompatible(ModuleConfigData<?> other) {
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.value == ((ModuleEnumData)other).value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleEnumData other = (ModuleEnumData)o;
        return this.enumConstants.equals(other.enumConstants) && this.defaultValue == other.defaultValue && this.value == other.value;
    }

    public int hashCode() {
        return Objects.hash(this.enumConstants, this.defaultValue, this.value);
    }
}

