/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.math;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.MathUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;

@NothingNullByDefault
public class FloatingLong
extends Number
implements Comparable<FloatingLong> {
    public static final Codec<FloatingLong> CODEC = new PrimitiveCodec<FloatingLong>(){

        public <T> DataResult<FloatingLong> read(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(number -> FloatingLong.fromNumber(number, true));
        }

        public <T> T write(DynamicOps<T> ops, FloatingLong value) {
            return (T)ops.createNumeric((Number)value);
        }
    };
    public static final Codec<FloatingLong> NONZERO_CODEC = ExtraCodecs.validate(CODEC, f -> {
        if (f.isZero()) {
            return DataResult.error(() -> "Value must be greater than zero");
        }
        return DataResult.success((Object)f);
    });
    private static final DecimalFormat df = new DecimalFormat("0.0000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final int DECIMAL_DIGITS = 4;
    private static final short MAX_DECIMAL = 9999;
    private static final short SINGLE_UNIT = 10000;
    private static final long MAX_LONG_SHIFT = Long.divideUnsigned(Long.divideUnsigned(-1L, 10000L), 10000L);
    public static final FloatingLong ZERO = FloatingLong.createConst(0L);
    public static final FloatingLong ONE = FloatingLong.createConst(1L);
    public static final FloatingLong MAX_VALUE = FloatingLong.createConst(-1L, (short)9999);
    private static final double MAX_AS_DOUBLE = Double.parseDouble(MAX_VALUE.toString());
    private final boolean isConstant;
    private long value;
    private short decimal;

    public static FloatingLong create(double value) {
        if (value > MAX_AS_DOUBLE) {
            return MAX_VALUE;
        }
        if (value < 0.0) {
            return ZERO;
        }
        long lValue = (long)value;
        short decimal = FloatingLong.parseDecimal(df.format(value));
        return FloatingLong.create(lValue, decimal);
    }

    public static FloatingLong create(long value) {
        return new FloatingLong(value, 0, false);
    }

    public static FloatingLong create(long value, short decimal) {
        return new FloatingLong(value, FloatingLong.clampDecimal(decimal), false);
    }

    public static FloatingLong createConst(double value) {
        if (value > MAX_AS_DOUBLE) {
            return MAX_VALUE;
        }
        if (value < 0.0) {
            return ZERO;
        }
        long lValue = (long)value;
        short decimal = FloatingLong.parseDecimal(df.format(value));
        return FloatingLong.createConst(lValue, decimal);
    }

    public static FloatingLong createConst(long value) {
        return new FloatingLong(value, 0, true);
    }

    public static FloatingLong createConst(long value, short decimal) {
        return new FloatingLong(value, FloatingLong.clampDecimal(decimal), true);
    }

    public static FloatingLong readFromBuffer(FriendlyByteBuf buffer) {
        return FloatingLong.createConst(buffer.readVarLong(), buffer.readShort());
    }

    private FloatingLong(long value, short decimal, boolean isConstant) {
        this.value = value;
        this.decimal = decimal;
        this.isConstant = isConstant;
    }

    public long getValue() {
        return this.value;
    }

    public short getDecimal() {
        return this.decimal;
    }

    private FloatingLong setAndClampValues(long value, short decimal) {
        if (this.isConstant) {
            return FloatingLong.create(value, decimal);
        }
        this.value = value;
        this.decimal = FloatingLong.clampDecimal(decimal);
        return this;
    }

    private static short clampDecimal(short decimal) {
        if (decimal < 0) {
            return 0;
        }
        if (decimal > 9999) {
            return 9999;
        }
        return decimal;
    }

    public boolean isZero() {
        return this.value == 0L && this.decimal <= 0;
    }

    public FloatingLong copy() {
        return new FloatingLong(this.value, this.decimal, false);
    }

    public FloatingLong copyAsConst() {
        return this.isConstant ? this : new FloatingLong(this.value, this.decimal, true);
    }

    public FloatingLong plusEqual(FloatingLong toAdd) {
        return this.plusEqual(toAdd.value, toAdd.decimal);
    }

    private FloatingLong plusEqual(long toAddValue, short toAddDecimal) {
        if (toAddDecimal == 0) {
            return this.plusEqual(toAddValue);
        }
        if (this.value < 0L && toAddValue < 0L || (this.value < 0L || toAddValue < 0L) && this.value + toAddValue >= 0L) {
            return this.isConstant ? MAX_VALUE : this.setAndClampValues(-1L, (short)9999);
        }
        long newValue = this.value + toAddValue;
        int newDecimal = this.decimal + toAddDecimal;
        if (newDecimal > 9999) {
            if (newValue == -1L) {
                newDecimal = 9999;
            } else {
                newDecimal = (short)(newDecimal - 10000);
                ++newValue;
            }
        }
        return this.setAndClampValues(newValue, (short)newDecimal);
    }

    public FloatingLong plusEqual(long toAdd) {
        if (toAdd == 0L) {
            return this;
        }
        if (this.value < 0L && toAdd < 0L || (this.value < 0L || toAdd < 0L) && this.value + toAdd >= 0L) {
            return this.isConstant ? MAX_VALUE : this.setAndClampValues(-1L, (short)9999);
        }
        return this.setAndClampValues(this.value + toAdd, this.decimal);
    }

    public FloatingLong minusEqual(FloatingLong toSubtract) {
        if (toSubtract.isZero() || this.isZero()) {
            return this;
        }
        if (toSubtract.greaterOrEqual(this)) {
            return this.isConstant ? ZERO : this.setAndClampValues(0L, (short)0);
        }
        long newValue = this.value - toSubtract.value;
        short newDecimal = (short)(this.decimal - toSubtract.decimal);
        if (newDecimal < 0) {
            newDecimal = (short)(newDecimal + 10000);
            --newValue;
        }
        return this.setAndClampValues(newValue, newDecimal);
    }

    public FloatingLong minusEqual(long toSubtract) {
        if (toSubtract == 0L || this.isZero()) {
            return this;
        }
        long comparison = Long.compareUnsigned(this.value, toSubtract);
        if (comparison < 0L || comparison == 0L && this.decimal == 0) {
            return this.isConstant ? ZERO : this.setAndClampValues(0L, (short)0);
        }
        return this.setAndClampValues(this.value - toSubtract, this.decimal);
    }

    public FloatingLong timesEqual(FloatingLong toMultiply) {
        if (this.isZero() || toMultiply.equals(ONE)) {
            return this;
        }
        if (toMultiply.isZero()) {
            return this.isConstant ? ZERO : this.setAndClampValues(0L, (short)0);
        }
        if (this.equals(ONE)) {
            return this.setAndClampValues(toMultiply.value, toMultiply.decimal);
        }
        if (FloatingLong.multiplyLongsWillOverFlow(this.value, toMultiply.value)) {
            return this.isConstant ? MAX_VALUE : this.setAndClampValues(-1L, (short)9999);
        }
        FloatingLong temp = FloatingLong.multiplyLongAndDecimal(this.value, toMultiply.decimal);
        temp = temp.plusEqual(FloatingLong.multiplyLongs(this.value, toMultiply.value));
        temp = FloatingLong.addLongAndDecimalMultiplication(temp, toMultiply.value, this.decimal);
        temp = temp.plusEqual(0L, FloatingLong.multiplyDecimals(this.decimal, toMultiply.decimal));
        if (this.isConstant) {
            return temp;
        }
        return this.setAndClampValues(temp.value, temp.decimal);
    }

    public FloatingLong timesEqual(long toMultiply) {
        if (toMultiply == 1L || this.isZero()) {
            return this;
        }
        if (toMultiply == 0L) {
            return this.isConstant ? ZERO : this.setAndClampValues(0L, (short)0);
        }
        if (this.equals(ONE)) {
            return this.setAndClampValues(toMultiply, (short)0);
        }
        if (FloatingLong.multiplyLongsWillOverFlow(this.value, toMultiply)) {
            return this.isConstant ? MAX_VALUE : this.setAndClampValues(-1L, (short)9999);
        }
        FloatingLong temp = FloatingLong.multiplyLongAndDecimal(toMultiply, this.decimal);
        temp = temp.plusEqual(FloatingLong.multiplyLongs(this.value, toMultiply));
        if (this.isConstant) {
            return temp;
        }
        return this.setAndClampValues(temp.value, temp.decimal);
    }

    public FloatingLong divideEquals(FloatingLong toDivide) {
        if (toDivide.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.isZero() || toDivide.equals(ONE)) {
            return this;
        }
        if (toDivide.decimal == 0) {
            return this.divideEquals(toDivide.value);
        }
        BigDecimal divide = new BigDecimal(this.toString()).divide(new BigDecimal(toDivide.toString()), 4, RoundingMode.HALF_UP);
        long value = divide.longValue();
        short decimal = FloatingLong.parseDecimal(divide.toPlainString());
        return this.setAndClampValues(value, decimal);
    }

    public FloatingLong divideEquals(long toDivide) {
        long dec;
        if (toDivide == 0L) {
            throw new ArithmeticException("Division by zero");
        }
        if (this.isZero() || toDivide == 1L) {
            return this;
        }
        long val = Long.divideUnsigned(this.value, toDivide);
        long rem = Long.remainderUnsigned(this.value, toDivide);
        if (Long.compareUnsigned(rem, MAX_LONG_SHIFT / 10L) >= 0) {
            dec = Long.divideUnsigned(rem, Long.divideUnsigned(toDivide, 100000L));
        } else {
            dec = Long.divideUnsigned(rem * 10000L * 10L, toDivide);
            dec += Long.divideUnsigned((long)this.decimal * 10L, toDivide);
        }
        if (Long.remainderUnsigned(dec, 10L) >= 5L && (dec += 10L) >= 100000L) {
            ++val;
            dec -= 100000L;
        }
        return this.setAndClampValues(val, (short)(dec /= 10L));
    }

    public long divideToUnsignedLong(FloatingLong toDivide) {
        if (toDivide.isZero()) {
            throw new ArithmeticException("Division by zero");
        }
        if (toDivide.equals(ONE)) {
            return this.value;
        }
        if (this.smallerThan(toDivide)) {
            return 0L;
        }
        if (toDivide.greaterThan(ONE)) {
            if (Long.compareUnsigned(toDivide.value, MAX_LONG_SHIFT) <= 0) {
                long div = toDivide.value * 10000L + (long)toDivide.decimal;
                return Long.divideUnsigned(this.value, div) * 10000L + Long.divideUnsigned(Long.remainderUnsigned(this.value, div) * 10000L, div);
            }
            if (Long.compareUnsigned(toDivide.value, Long.divideUnsigned(-1L, 2L) + 1L) >= 0) {
                return 1L;
            }
            long q = Long.divideUnsigned(this.value, toDivide.value);
            if (q != Long.divideUnsigned(this.value, toDivide.value + 1L) && toDivide.value * q + Long.divideUnsigned((long)toDivide.decimal * q, 9999L) > this.value) {
                return q - 1L;
            }
            return q;
        }
        if (Long.compareUnsigned(this.value, MAX_LONG_SHIFT) >= 0) {
            return Long.divideUnsigned(this.value, toDivide.decimal) * 9999L + Long.divideUnsigned(Long.remainderUnsigned(this.value, toDivide.decimal) * 9999L, toDivide.decimal) + (long)this.decimal * 9999L / (long)toDivide.decimal;
        }
        long d = this.value * 9999L;
        return Long.divideUnsigned(d, toDivide.decimal) + (long)this.decimal * 9999L / (long)toDivide.decimal;
    }

    public long divideToLong(FloatingLong toDivide) {
        return MathUtils.clampUnsignedToLong(this.divideToUnsignedLong(toDivide));
    }

    public int divideToInt(FloatingLong toDivide) {
        return MathUtils.clampUnsignedToInt(this.divideToLong(toDivide));
    }

    public FloatingLong add(FloatingLong toAdd) {
        return this.copy().plusEqual(toAdd);
    }

    public FloatingLong add(long toAdd) {
        return this.copy().plusEqual(toAdd);
    }

    public FloatingLong add(double toAdd) {
        if (toAdd < 0.0) {
            throw new IllegalArgumentException("Addition called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.add(FloatingLong.create(toAdd));
    }

    public FloatingLong subtract(FloatingLong toSubtract) {
        return this.copy().minusEqual(toSubtract);
    }

    public FloatingLong subtract(long toSubtract) {
        return this.copy().minusEqual(toSubtract);
    }

    public FloatingLong subtract(double toSubtract) {
        if (toSubtract < 0.0) {
            throw new IllegalArgumentException("Subtraction called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.subtract(FloatingLong.create(toSubtract));
    }

    public FloatingLong multiply(FloatingLong toMultiply) {
        return this.copy().timesEqual(toMultiply);
    }

    public FloatingLong multiply(long toMultiply) {
        return this.copy().timesEqual(toMultiply);
    }

    public FloatingLong multiply(double toMultiply) {
        if (toMultiply < 0.0) {
            throw new IllegalArgumentException("Multiply called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.multiply(FloatingLong.createConst(toMultiply));
    }

    public FloatingLong divide(FloatingLong toDivide) {
        return this.copy().divideEquals(toDivide);
    }

    public FloatingLong divide(long toDivide) {
        return this.copy().divideEquals(toDivide);
    }

    public FloatingLong divide(double toDivide) {
        if (toDivide < 0.0) {
            throw new IllegalArgumentException("Division called with negative number, this is not supported. FloatingLongs are always positive.");
        }
        return this.divide(FloatingLong.create(toDivide));
    }

    public double divideToLevel(FloatingLong toDivide) {
        return toDivide.isZero() || this.greaterThan(toDivide) ? 1.0 : this.divide(toDivide).doubleValue();
    }

    public FloatingLong max(FloatingLong other) {
        return this.smallerThan(other) ? other : this;
    }

    public FloatingLong min(FloatingLong other) {
        return this.greaterThan(other) ? other : this;
    }

    public FloatingLong ceil() {
        if (this.decimal == 0) {
            return this;
        }
        if (this.value == -1L) {
            return new FloatingLong(this.value, 0, false);
        }
        return new FloatingLong(this.value + 1L, 0, false);
    }

    public FloatingLong ceilSelf() {
        if (this.decimal == 0) {
            return this;
        }
        if (this.value == -1L) {
            return this.setAndClampValues(this.value, (short)0);
        }
        return this.setAndClampValues(this.value + 1L, (short)0);
    }

    public FloatingLong floor() {
        return this.decimal == 0 ? this : new FloatingLong(this.value, 0, false);
    }

    public FloatingLong floorSelf() {
        return this.decimal == 0 ? this : this.setAndClampValues(this.value, (short)0);
    }

    public boolean smallerThan(FloatingLong toCompare) {
        return this.compareTo(toCompare) < 0;
    }

    public boolean smallerOrEqual(FloatingLong toCompare) {
        return this.compareTo(toCompare) <= 0;
    }

    public boolean greaterThan(FloatingLong toCompare) {
        return this.compareTo(toCompare) > 0;
    }

    public boolean greaterOrEqual(FloatingLong toCompare) {
        return this.compareTo(toCompare) >= 0;
    }

    @Override
    public int compareTo(FloatingLong toCompare) {
        int valueCompare = Long.compareUnsigned(this.value, toCompare.value);
        if (valueCompare == 0) {
            if (this.decimal < toCompare.decimal) {
                return -2;
            }
            if (this.decimal > toCompare.decimal) {
                return 2;
            }
            return 0;
        }
        return valueCompare;
    }

    public boolean equals(FloatingLong other) {
        return this.value == other.value && this.decimal == other.decimal;
    }

    public boolean equals(Object o) {
        FloatingLong other;
        return this == o || o instanceof FloatingLong && this.equals(other = (FloatingLong)o);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.decimal);
    }

    @Override
    public byte byteValue() {
        int v = this.intValue();
        if (v < 127) {
            return (byte)v;
        }
        return 127;
    }

    @Override
    public short shortValue() {
        int v = this.intValue();
        if (v < Short.MAX_VALUE) {
            return (short)v;
        }
        return Short.MAX_VALUE;
    }

    @Override
    public int intValue() {
        return MathUtils.clampUnsignedToInt(this.value);
    }

    @Override
    public long longValue() {
        return MathUtils.clampUnsignedToLong(this.value);
    }

    @Override
    public float floatValue() {
        return MathUtils.unsignedLongToFloat(this.value) + (float)this.decimal / 10000.0f;
    }

    @Override
    public double doubleValue() {
        return MathUtils.unsignedLongToDouble(this.value) + (double)this.decimal / 10000.0;
    }

    public FloatingLong absDifference(FloatingLong other) {
        if (this.greaterThan(other)) {
            return this.subtract(other);
        }
        return this.add(other);
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.writeVarLong(this.value);
        buffer.writeShort((int)this.decimal);
    }

    public String toString() {
        return this.toString(4);
    }

    public String toString(int decimalPlaces) {
        if (this.decimal == 0) {
            return Long.toUnsignedString(this.value);
        }
        if (decimalPlaces > 4) {
            decimalPlaces = 4;
        }
        String valueAsString = Long.toUnsignedString(this.value) + ".";
        Object decimalAsString = Short.toString(this.decimal);
        int numberDigits = ((String)decimalAsString).length();
        if (numberDigits < 4) {
            decimalAsString = FloatingLong.getZeros(4 - numberDigits) + (String)decimalAsString;
            numberDigits = 4;
        }
        if (numberDigits > decimalPlaces) {
            decimalAsString = ((String)decimalAsString).substring(0, decimalPlaces);
        }
        return valueAsString + (String)decimalAsString;
    }

    public static FloatingLong parseFloatingLong(String string) {
        return FloatingLong.parseFloatingLong(string, false);
    }

    public static FloatingLong parseFloatingLong(String string, boolean isConstant) {
        int index = string.indexOf(46);
        long value = index == -1 ? Long.parseUnsignedLong(string) : Long.parseUnsignedLong(string.substring(0, index));
        short decimal = FloatingLong.parseDecimal(string, index);
        return isConstant ? FloatingLong.createConst(value, decimal) : FloatingLong.create(value, decimal);
    }

    private static FloatingLong fromNumber(Number number, boolean isConstant) {
        if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte || number instanceof BigInteger) {
            long longValue = number.longValue();
            if (longValue < 0L) {
                throw new NumberFormatException("Number must be positive");
            }
            return isConstant ? FloatingLong.createConst(longValue, (short)0) : FloatingLong.create(longValue, (short)0);
        }
        if (number instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)number;
            try {
                long longValue = decimal.longValueExact();
                return isConstant ? FloatingLong.createConst(longValue, (short)0) : FloatingLong.create(longValue, (short)0);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        return FloatingLong.parseFloatingLong(number.toString(), isConstant);
    }

    private static short parseDecimal(String string) {
        return FloatingLong.parseDecimal(string, string.indexOf(46));
    }

    private static short parseDecimal(String string, int index) {
        if (index == -1) {
            return 0;
        }
        Object decimalAsString = string.substring(index + 1);
        int numberDigits = ((String)decimalAsString).length();
        if (numberDigits < 4) {
            decimalAsString = (String)decimalAsString + FloatingLong.getZeros(4 - numberDigits);
        } else if (numberDigits > 4) {
            decimalAsString = ((String)decimalAsString).substring(0, 4);
        }
        return Short.parseShort((String)decimalAsString);
    }

    private static String getZeros(int number) {
        return "0".repeat(Math.max(0, number));
    }

    private static boolean multiplyLongsWillOverFlow(long a, long b) {
        return a != 0L && b != 0L && Long.compareUnsigned(b, Long.divideUnsigned(-1L, a)) > 0;
    }

    private static long multiplyLongs(long a, long b) {
        if (a == 0L || b == 0L) {
            return 0L;
        }
        if (FloatingLong.multiplyLongsWillOverFlow(a, b)) {
            return -1L;
        }
        return a * b;
    }

    private static FloatingLong multiplyLongAndDecimal(long value, short decimal) {
        if (value == 0L || decimal == 0) {
            return ZERO;
        }
        if (Long.compareUnsigned(value, Long.divideUnsigned(-1L, 10000L)) > 0) {
            return FloatingLong.create(Long.divideUnsigned(value, 10000L) * (long)decimal, (short)(value % 10000L * (long)decimal));
        }
        return new FloatingLong(Long.divideUnsigned(value * (long)decimal, 10000L), (short)(value * (long)decimal % 10000L), false);
    }

    private static FloatingLong addLongAndDecimalMultiplication(FloatingLong base, long value, short decimal) {
        if (value == 0L || decimal == 0) {
            return base;
        }
        if (Long.compareUnsigned(value, Long.divideUnsigned(-1L, 10000L)) > 0) {
            return base.plusEqual(Long.divideUnsigned(value, 10000L) * (long)decimal, FloatingLong.clampDecimal((short)(value % 10000L * (long)decimal)));
        }
        return base.plusEqual(Long.divideUnsigned(value * (long)decimal, 10000L), (short)(value * (long)decimal % 10000L));
    }

    private static short multiplyDecimals(short a, short b) {
        long temp = (long)a * (long)b / 10000L;
        return FloatingLong.clampDecimal((short)temp);
    }
}

