/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.math;

import it.unimi.dsi.fastutil.ints.Int2ObjectFunction;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.container.ContainerInteraction;
import mekanism.api.container.InContainerGetter;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FloatingLongTransferUtils {
    private FloatingLongTransferUtils() {
    }

    @Deprecated(forRemoval=true, since="10.5.13")
    public static FloatingLong insert(FloatingLong stack, Action action, IntSupplier containerCount, Int2ObjectFunction<FloatingLong> inContainerGetter, InsertFloatingLong insert) {
        if (stack.isZero()) {
            return FloatingLong.ZERO;
        }
        return FloatingLongTransferUtils.insert(stack, null, action, side -> containerCount.getAsInt(), (container, s) -> (FloatingLong)inContainerGetter.apply(container), (container, amt, side, a) -> insert.insert(container, (FloatingLong)amt, a));
    }

    public static FloatingLong insert(FloatingLong stack, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> containerCount, InContainerGetter<FloatingLong> inContainerGetter, ContainerInteraction<FloatingLong> insert) {
        FloatingLong remainder;
        if (stack.isZero()) {
            return FloatingLong.ZERO;
        }
        int containers = containerCount.applyAsInt(side);
        if (containers == 0) {
            return stack;
        }
        if (containers == 1) {
            return insert.interact(0, stack, side, action);
        }
        FloatingLong toInsert = stack;
        IntArrayList emptyContainers = new IntArrayList();
        for (int container = 0; container < containers; ++container) {
            FloatingLong inContainer = inContainerGetter.getStored(container, side);
            if (inContainer.isZero()) {
                emptyContainers.add(container);
                continue;
            }
            remainder = insert.interact(container, toInsert, side, action);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        IntListIterator intListIterator = emptyContainers.iterator();
        while (intListIterator.hasNext()) {
            int container = (Integer)intListIterator.next();
            remainder = insert.interact(container, toInsert, side, action);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static FloatingLong insert(FloatingLong stack, @Nullable Direction side, Function<@Nullable Direction, List<IEnergyContainer>> energyContainerSupplier, Action action, AutomationType automationType) {
        if (stack.isZero()) {
            return FloatingLong.ZERO;
        }
        List<IEnergyContainer> energyContainers = energyContainerSupplier.apply(side);
        if (energyContainers.isEmpty()) {
            return stack;
        }
        if (energyContainers.size() == 1) {
            return energyContainers.get(0).insert(stack, action, automationType);
        }
        FloatingLong toInsert = stack;
        ArrayList<IEnergyContainer> emptyContainers = new ArrayList<IEnergyContainer>();
        for (IEnergyContainer energyContainer : energyContainers) {
            FloatingLong inContainer = energyContainer.getEnergy();
            if (inContainer.isZero()) {
                emptyContainers.add(energyContainer);
                continue;
            }
            FloatingLong remainder = energyContainer.insert(toInsert, action, automationType);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        for (IEnergyContainer container : emptyContainers) {
            FloatingLong remainder = container.insert(toInsert, action, automationType);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    @Deprecated(forRemoval=true, since="10.5.13")
    public static FloatingLong extract(FloatingLong amount, Action action, IntSupplier containerCount, ExtractFloatingLong extract) {
        if (amount.isZero()) {
            return FloatingLong.ZERO;
        }
        return FloatingLongTransferUtils.extract(amount, null, action, (Direction side) -> containerCount.getAsInt(), (int container, FloatingLong amt, Direction side, Action a) -> extract.extract(container, (FloatingLong)amt, a));
    }

    public static FloatingLong extract(FloatingLong amount, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> containerCount, ContainerInteraction<FloatingLong> extract) {
        if (amount.isZero()) {
            return FloatingLong.ZERO;
        }
        int containers = containerCount.applyAsInt(side);
        if (containers == 0) {
            return FloatingLong.ZERO;
        }
        if (containers == 1) {
            return extract.interact(0, amount, side, action);
        }
        FloatingLong extracted = FloatingLong.ZERO;
        FloatingLong toExtract = amount.copy();
        for (int container = 0; container < containers; ++container) {
            FloatingLong drained = extract.interact(container, toExtract, side, action);
            if (drained.isZero()) continue;
            extracted = extracted.isZero() ? drained : extracted.plusEqual(drained);
            if ((toExtract = toExtract.minusEqual(drained)).isZero()) break;
        }
        return extracted;
    }

    public static FloatingLong extract(FloatingLong amount, @Nullable Direction side, Function<@Nullable Direction, List<IEnergyContainer>> energyContainerSupplier, Action action, AutomationType automationType) {
        if (amount.isZero()) {
            return FloatingLong.ZERO;
        }
        List<IEnergyContainer> energyContainers = energyContainerSupplier.apply(side);
        if (energyContainers.isEmpty()) {
            return FloatingLong.ZERO;
        }
        if (energyContainers.size() == 1) {
            return energyContainers.get(0).extract(amount, action, automationType);
        }
        FloatingLong extracted = FloatingLong.ZERO;
        FloatingLong toExtract = amount.copy();
        for (IEnergyContainer energyContainer : energyContainers) {
            FloatingLong drained = energyContainer.extract(toExtract, action, automationType);
            if (drained.isZero()) continue;
            extracted = extracted.isZero() ? drained : extracted.plusEqual(drained);
            if (!(toExtract = toExtract.minusEqual(drained)).isZero()) continue;
            break;
        }
        return extracted;
    }

    @FunctionalInterface
    @Deprecated(forRemoval=true, since="10.5.13")
    public static interface InsertFloatingLong {
        public FloatingLong insert(int var1, FloatingLong var2, Action var3);
    }

    @FunctionalInterface
    @Deprecated(forRemoval=true, since="10.5.13")
    public static interface ExtractFloatingLong {
        public FloatingLong extract(int var1, FloatingLong var2, Action var3);
    }
}

