/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.radiation;

import com.google.common.collect.Table;
import java.util.List;
import java.util.ServiceLoader;
import mekanism.api.Chunk3D;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.radiation.IRadiationSource;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@NothingNullByDefault
public interface IRadiationManager {
    public static final IRadiationManager INSTANCE = ServiceLoader.load(IRadiationManager.class).findFirst().orElseThrow(() -> new IllegalStateException("No valid ServiceImpl for IRadiationManager found"));

    public boolean isRadiationEnabled();

    public DamageSource getRadiationDamageSource(RegistryAccess var1);

    public ResourceKey<DamageType> getRadiationDamageTypeKey();

    public double getRadiationLevel(GlobalPos var1);

    public double getRadiationLevel(Entity var1);

    public Table<Chunk3D, GlobalPos, IRadiationSource> getRadiationSources();

    public void removeRadiationSources(Chunk3D var1);

    public void removeRadiationSource(GlobalPos var1);

    public void radiate(GlobalPos var1, double var2);

    public void radiate(LivingEntity var1, double var2);

    public void dumpRadiation(GlobalPos var1, IGasHandler var2, boolean var3);

    public void dumpRadiation(GlobalPos var1, List<IGasTank> var2, boolean var3);

    public boolean dumpRadiation(GlobalPos var1, GasStack var2);
}

