/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.List;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class ChemicalDissolutionRecipe
extends MekanismRecipe
implements BiPredicate<ItemStack, GasStack> {
    private static final Holder<Item> CHEMICAL_DISSOLUTION_CHAMBER = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("mekanism", "chemical_dissolution_chamber"));

    public abstract ItemStackIngredient getItemInput();

    public abstract ChemicalStackIngredient.GasStackIngredient getGasInput();

    @Contract(value="_, _ -> new", pure=true)
    public abstract BoxedChemicalStack getOutput(ItemStack var1, GasStack var2);

    @Override
    public abstract boolean test(ItemStack var1, GasStack var2);

    public abstract List<BoxedChemicalStack> getOutputDefinition();

    @Override
    public boolean isIncomplete() {
        return this.getItemInput().hasNoMatchingInstances() || this.getGasInput().hasNoMatchingInstances();
    }

    public final RecipeType<ChemicalDissolutionRecipe> getType() {
        return (RecipeType)MekanismRecipeTypes.TYPE_DISSOLUTION.value();
    }

    public String getGroup() {
        return "chemical_dissolution_chamber";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack(CHEMICAL_DISSOLUTION_CHAMBER);
    }
}

