/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.List;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class CombinerRecipe
extends MekanismRecipe
implements BiPredicate<ItemStack, ItemStack> {
    private static final Holder<Item> COMBINER = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("mekanism", "combiner"));

    @Override
    public abstract boolean test(ItemStack var1, ItemStack var2);

    public abstract ItemStackIngredient getMainInput();

    public abstract ItemStackIngredient getExtraInput();

    @Contract(value="_, _ -> new", pure=true)
    public abstract ItemStack getOutput(@NotNull ItemStack var1, @NotNull ItemStack var2);

    @Override
    @NotNull
    public abstract ItemStack getResultItem(@NotNull RegistryAccess var1);

    public abstract List<ItemStack> getOutputDefinition();

    @Override
    public boolean isIncomplete() {
        return this.getMainInput().hasNoMatchingInstances() || this.getExtraInput().hasNoMatchingInstances();
    }

    public final RecipeType<CombinerRecipe> getType() {
        return (RecipeType)MekanismRecipeTypes.TYPE_COMBINING.value();
    }

    public String getGroup() {
        return "combiner";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack(COMBINER);
    }
}

