/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class ElectrolysisRecipe
extends MekanismRecipe
implements Predicate<FluidStack> {
    private static final Holder<Item> ELECTROLYTIC_SEPARATOR = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)new ResourceLocation("mekanism", "electrolytic_separator"));

    public abstract FluidStackIngredient getInput();

    public abstract List<ElectrolysisRecipeOutput> getOutputDefinition();

    @Override
    public abstract boolean test(FluidStack var1);

    @Contract(value="_ -> new", pure=true)
    public abstract ElectrolysisRecipeOutput getOutput(FluidStack var1);

    public abstract FloatingLong getEnergyMultiplier();

    @Override
    public boolean isIncomplete() {
        return this.getInput().hasNoMatchingInstances();
    }

    public final RecipeType<ElectrolysisRecipe> getType() {
        return (RecipeType)MekanismRecipeTypes.TYPE_SEPARATING.value();
    }

    public ItemStack getToastSymbol() {
        return new ItemStack(ELECTROLYTIC_SEPARATOR);
    }

    public record ElectrolysisRecipeOutput(@NotNull GasStack left, @NotNull GasStack right) {
        public ElectrolysisRecipeOutput(@NotNull GasStack left, @NotNull GasStack right) {
            Objects.requireNonNull(left, "Left output cannot be null.");
            Objects.requireNonNull(right, "Right output cannot be null.");
            if (left.isEmpty()) {
                throw new IllegalArgumentException("Left output cannot be empty.");
            }
            if (right.isEmpty()) {
                throw new IllegalArgumentException("Right output cannot be empty.");
            }
        }
    }
}

