/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class BasicChemicalCrystallizerRecipe
extends ChemicalCrystallizerRecipe {
    protected final ChemicalType chemicalType;
    protected final ChemicalStackIngredient<?, ?> input;
    protected final ItemStack output;

    public BasicChemicalCrystallizerRecipe(ChemicalStackIngredient<?, ?> input, ItemStack output) {
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        this.chemicalType = ChemicalType.getTypeFor(input);
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public ItemStack getOutput(BoxedChemicalStack input) {
        return this.output.copy();
    }

    @Override
    @NotNull
    public ItemStack getResultItem(@NotNull RegistryAccess registryAccess) {
        return this.output.copy();
    }

    @Override
    public List<ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    public boolean test(BoxedChemicalStack chemicalStack) {
        return this.chemicalType == chemicalStack.getChemicalType() && this.testInternal(chemicalStack.getChemicalStack());
    }

    @Override
    public boolean test(ChemicalStack<?> stack) {
        return this.chemicalType == ChemicalType.getTypeFor(stack) && this.testInternal(stack);
    }

    @Override
    public boolean testType(ChemicalStack<?> stack) {
        return this.chemicalType == ChemicalType.getTypeFor(stack) && this.testTypeInternal(stack);
    }

    @Override
    public boolean testType(BoxedChemicalStack stack) {
        return this.chemicalType == stack.getChemicalType() && this.testTypeInternal(stack.getChemicalStack());
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean testInternal(STACK stack) {
        return this.input.test(stack);
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean testTypeInternal(STACK stack) {
        return this.input.testType(stack);
    }

    @Override
    public ChemicalStackIngredient<?, ?> getInput() {
        return this.input;
    }

    public ItemStack getOutputRaw() {
        return this.output;
    }

    public ChemicalType getChemicalType() {
        return this.chemicalType;
    }

    public RecipeSerializer<BasicChemicalCrystallizerRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.CRYSTALLIZING.get();
    }
}

