/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.basic.IBasicChemicalOutput;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public class BasicChemicalInfuserRecipe
extends ChemicalInfuserRecipe
implements IBasicChemicalOutput<Gas, GasStack> {
    protected final ChemicalStackIngredient.GasStackIngredient leftInput;
    protected final ChemicalStackIngredient.GasStackIngredient rightInput;
    protected final GasStack output;

    public BasicChemicalInfuserRecipe(ChemicalStackIngredient.GasStackIngredient leftInput, ChemicalStackIngredient.GasStackIngredient rightInput, GasStack output) {
        this.leftInput = Objects.requireNonNull(leftInput, "Left input cannot be null.");
        this.rightInput = Objects.requireNonNull(rightInput, "Right input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    @Override
    public boolean test(GasStack input1, GasStack input2) {
        return this.leftInput.test(input1) && this.rightInput.test(input2) || this.rightInput.test(input1) && this.leftInput.test(input2);
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public GasStack getOutput(GasStack input1, GasStack input2) {
        return this.output.copy();
    }

    @Override
    public ChemicalStackIngredient.GasStackIngredient getLeftInput() {
        return this.leftInput;
    }

    @Override
    public ChemicalStackIngredient.GasStackIngredient getRightInput() {
        return this.rightInput;
    }

    @Override
    public List<GasStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    public GasStack getOutputRaw() {
        return this.output;
    }

    public RecipeSerializer<BasicChemicalInfuserRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.CHEMICAL_INFUSING.get();
    }
}

