/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class BasicGasToGasRecipe
extends GasToGasRecipe {
    protected final GasStack output;
    private final ChemicalStackIngredient.GasStackIngredient input;

    public BasicGasToGasRecipe(ChemicalStackIngredient.GasStackIngredient input, GasStack output, RecipeType<GasToGasRecipe> recipeType) {
        super(recipeType);
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    @Override
    public boolean test(GasStack chemicalStack) {
        return this.input.test(chemicalStack);
    }

    @Override
    public ChemicalStackIngredient.GasStackIngredient getInput() {
        return this.input;
    }

    @Override
    public List<GasStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public GasStack getOutput(GasStack input) {
        return this.output.copy();
    }

    public GasStack getOutputRaw() {
        return this.output;
    }
}

