/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

@NothingNullByDefault
public class BasicItemStackToEnergyRecipe
extends ItemStackToEnergyRecipe {
    protected final ItemStackIngredient input;
    protected final FloatingLong output;

    public BasicItemStackToEnergyRecipe(ItemStackIngredient input, FloatingLong output) {
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isZero()) {
            throw new IllegalArgumentException("Output must be greater than zero.");
        }
        this.output = output.copyAsConst();
    }

    @Override
    public boolean test(ItemStack itemStack) {
        return this.input.test(itemStack);
    }

    @Override
    public ItemStackIngredient getInput() {
        return this.input;
    }

    @Override
    public FloatingLong getOutput(ItemStack input) {
        return this.output;
    }

    @Override
    public List<FloatingLong> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public RecipeSerializer<BasicItemStackToEnergyRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.ENERGY_CONVERSION.get();
    }
}

