/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class ChemicalChemicalToChemicalCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NotNull STACK> outputHandler;
    private final IInputHandler<@NotNull STACK> leftInputHandler;
    private final IInputHandler<@NotNull STACK> rightInputHandler;
    private final BiConsumer<STACK, STACK> inputsSetter;
    private final Consumer<STACK> outputSetter;
    private final Supplier<INGREDIENT> leftInput;
    private final Supplier<INGREDIENT> rightInput;
    private final BinaryOperator<STACK> outputGetter;
    @Nullable
    private STACK leftRecipeInput;
    @Nullable
    private STACK rightRecipeInput;
    @Nullable
    private STACK output;

    public ChemicalChemicalToChemicalCachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull STACK> leftInputHandler, IInputHandler<@NotNull STACK> rightInputHandler, IOutputHandler<@NotNull STACK> outputHandler) {
        super(recipe, recheckAllErrors);
        this.leftInputHandler = Objects.requireNonNull(leftInputHandler, "Left input handler cannot be null.");
        this.rightInputHandler = Objects.requireNonNull(rightInputHandler, "Right input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
        this.leftInput = ((ChemicalChemicalToChemicalRecipe)this.recipe)::getLeftInput;
        this.rightInput = ((ChemicalChemicalToChemicalRecipe)this.recipe)::getRightInput;
        this.inputsSetter = (left, right) -> {
            this.leftRecipeInput = left;
            this.rightRecipeInput = right;
        };
        this.outputSetter = output -> {
            this.output = output;
        };
        this.outputGetter = ((ChemicalChemicalToChemicalRecipe)this.recipe)::getOutput;
    }

    @Override
    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            ChemicalStack leftInputChemical = (ChemicalStack)this.leftInputHandler.getInput();
            if (leftInputChemical.isEmpty()) {
                tracker.mismatchedRecipe();
            } else {
                ChemicalStack rightInputChemical = (ChemicalStack)this.rightInputHandler.getInput();
                if (rightInputChemical.isEmpty()) {
                    tracker.mismatchedRecipe();
                } else {
                    Supplier<INGREDIENT> rightIngredient;
                    Supplier<INGREDIENT> leftIngredient;
                    if (!((ChemicalChemicalToChemicalRecipe)this.recipe).getLeftInput().test((ChemicalStack)leftInputChemical) || !((ChemicalChemicalToChemicalRecipe)this.recipe).getRightInput().test((ChemicalStack)rightInputChemical)) {
                        leftIngredient = this.rightInput;
                        rightIngredient = this.leftInput;
                    } else {
                        leftIngredient = this.leftInput;
                        rightIngredient = this.rightInput;
                    }
                    CachedRecipeHelper.twoInputCalculateOperationsThisTick(tracker, this.leftInputHandler, leftIngredient, this.rightInputHandler, rightIngredient, this.inputsSetter, this.outputHandler, this.outputGetter, this.outputSetter, ConstantPredicates.chemicalEmpty(), ConstantPredicates.chemicalEmpty());
                }
            }
        }
    }

    @Override
    public boolean isInputValid() {
        ChemicalStack leftInput = (ChemicalStack)this.leftInputHandler.getInput();
        if (leftInput.isEmpty()) {
            return false;
        }
        ChemicalStack rightInput = (ChemicalStack)this.rightInputHandler.getInput();
        return !rightInput.isEmpty() && ((ChemicalChemicalToChemicalRecipe)this.recipe).test(leftInput, rightInput);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (!(this.leftRecipeInput == null || this.rightRecipeInput == null || this.output == null || ((ChemicalStack)this.leftRecipeInput).isEmpty() || ((ChemicalStack)this.rightRecipeInput).isEmpty() || ((ChemicalStack)this.output).isEmpty())) {
            this.leftInputHandler.use(this.leftRecipeInput, operations);
            this.rightInputHandler.use(this.rightRecipeInput, operations);
            this.outputHandler.handleOutput(this.output, operations);
        }
    }
}

