/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.InputIngredient;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IIngredientCreator<TYPE, STACK, INGREDIENT extends InputIngredient<@NotNull STACK>> {
    public INGREDIENT from(STACK var1);

    public INGREDIENT from(TYPE var1, int var2);

    default public INGREDIENT fromHolder(Holder<TYPE> instance, int amount) {
        return this.from(instance.value(), amount);
    }

    public INGREDIENT from(TagKey<TYPE> var1, int var2);

    public INGREDIENT read(FriendlyByteBuf var1);

    @Deprecated(forRemoval=true)
    default public INGREDIENT deserialize(@Nullable JsonElement json) {
        return (INGREDIENT)((InputIngredient)this.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, e -> {}));
    }

    default public JsonElement serialize(INGREDIENT ingredient) {
        return (JsonElement)this.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, ingredient).getOrThrow(false, unused -> {});
    }

    public Codec<INGREDIENT> codec();

    public INGREDIENT createMulti(INGREDIENT ... var1);

    public INGREDIENT from(Stream<INGREDIENT> var1);
}

