/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.NBTIngredient;

@NothingNullByDefault
public interface IItemStackIngredientCreator
extends IIngredientCreator<Item, ItemStack, ItemStackIngredient> {
    @Override
    default public ItemStackIngredient from(ItemStack instance) {
        Objects.requireNonNull(instance, "ItemStackIngredients cannot be created from a null ItemStack.");
        return this.from(instance, instance.getCount());
    }

    @Override
    default public ItemStackIngredient from(ItemStack stack, int amount) {
        Objects.requireNonNull(stack, "ItemStackIngredients cannot be created from a null ItemStack.");
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be created using the empty stack.");
        }
        if ((stack = stack.copy()).hasTag() || stack.serializeAttachments() != null) {
            return this.from((Ingredient)NBTIngredient.of((boolean)false, (ItemStack)stack), amount);
        }
        return this.from(Ingredient.of((ItemStack[])new ItemStack[]{stack}), amount);
    }

    default public ItemStackIngredient fromHolder(Holder<Item> item) {
        return (ItemStackIngredient)this.fromHolder(item, 1);
    }

    @Override
    default public ItemStackIngredient from(ItemLike item) {
        return this.from(item, 1);
    }

    @Override
    default public ItemStackIngredient from(ItemLike item, int amount) {
        return this.from(new ItemStack(item), amount);
    }

    @Override
    default public ItemStackIngredient from(Item item, int amount) {
        return this.from((ItemLike)item, amount);
    }

    @Override
    default public ItemStackIngredient from(TagKey<Item> tag) {
        return this.from((TagKey)tag, 1);
    }

    @Override
    default public ItemStackIngredient from(TagKey<Item> tag, int amount) {
        Objects.requireNonNull(tag, "ItemStackIngredients cannot be created from a null tag.");
        return this.from(Ingredient.of(tag), amount);
    }

    @Override
    default public ItemStackIngredient from(Ingredient ingredient) {
        return this.from(ingredient, 1);
    }

    @Override
    public ItemStackIngredient from(Ingredient var1, int var2);
}

