/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.robit;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.robit.RobitSkin;
import mekanism.api.robit.RobitSkinSerializationHelper;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public record AdvancementBasedRobitSkin(List<ResourceLocation> textures, @Nullable ResourceLocation customModel, ResourceLocation advancement) implements RobitSkin
{
    public AdvancementBasedRobitSkin(List<ResourceLocation> textures, @Nullable ResourceLocation customModel, ResourceLocation advancement) {
        Objects.requireNonNull(advancement, "Required advancement cannot be null.");
        Objects.requireNonNull(textures, "Textures cannot be null.");
        if (textures.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one texture specified.");
        }
        textures = List.copyOf(textures);
    }

    public AdvancementBasedRobitSkin(List<ResourceLocation> textures, ResourceLocation advancement) {
        this(textures, null, advancement);
    }

    @Override
    public Codec<? extends RobitSkin> codec() {
        return RobitSkinSerializationHelper.ADVANCEMENT_BASED_ROBIT_SKIN_CODEC;
    }

    @Override
    public boolean isUnlocked(@NotNull Player player) {
        ServerPlayer serverPlayer;
        MinecraftServer server;
        if (player instanceof ServerPlayer && (server = (serverPlayer = (ServerPlayer)player).getServer()) != null) {
            AdvancementHolder advancement = server.getAdvancements().get(this.advancement());
            return advancement != null && serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone();
        }
        return true;
    }
}

