/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.security;

import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface ISecurityUtils {
    public static final ISecurityUtils INSTANCE = ServiceLoader.load(ISecurityUtils.class).findFirst().orElseThrow(() -> new IllegalStateException("No valid ServiceImpl for ISecurityUtils found"));

    public boolean canAccess(Player var1, Supplier<@Nullable ISecurityObject> var2, Supplier<@Nullable IOwnerObject> var3);

    public <PROVIDER> boolean canAccess(Player var1, PROVIDER var2, Function<PROVIDER, @Nullable ISecurityObject> var3, Function<PROVIDER, @Nullable IOwnerObject> var4);

    public boolean canAccessObject(Player var1, ISecurityObject var2);

    public boolean canAccess(@Nullable UUID var1, Supplier<@Nullable ISecurityObject> var2, Supplier<@Nullable IOwnerObject> var3, boolean var4);

    public <PROVIDER> boolean canAccess(@Nullable UUID var1, PROVIDER var2, Function<PROVIDER, @Nullable ISecurityObject> var3, Function<PROVIDER, @Nullable IOwnerObject> var4, boolean var5);

    public boolean canAccessObject(@Nullable UUID var1, ISecurityObject var2, boolean var3);

    public boolean moreRestrictive(SecurityMode var1, SecurityMode var2);

    public SecurityMode getSecurityMode(Supplier<@Nullable ISecurityObject> var1, Supplier<@Nullable IOwnerObject> var2, boolean var3);

    public <PROVIDER> SecurityMode getSecurityMode(PROVIDER var1, Function<PROVIDER, @Nullable ISecurityObject> var2, Function<PROVIDER, @Nullable IOwnerObject> var3, boolean var4);

    public SecurityMode getEffectiveSecurityMode(ISecurityObject var1, boolean var2);

    public void displayNoAccess(Player var1);
}

