/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.math.BigDecimal;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.tab.GuiAmplifierTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.network.to_server.PacketGuiSetEnergy;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiLaserAmplifier
extends GuiMekanismTile<TileEntityLaserAmplifier, MekanismTileContainer<TileEntityLaserAmplifier>> {
    private GuiTextField minField;
    private GuiTextField maxField;
    private GuiTextField timerField;

    public GuiLaserAmplifier(MekanismTileContainer<TileEntityLaserAmplifier> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiEnergyGauge(((TileEntityLaserAmplifier)this.tile).getEnergyContainer(), GaugeType.STANDARD, (IGuiWrapper)this, 6, 10));
        this.addRenderableWidget(new GuiAmplifierTab(this, (TileEntityLaserAmplifier)this.tile));
        this.timerField = this.addRenderableWidget(new GuiTextField(this, 96, 28, 36, 11));
        this.timerField.setMaxLength(4);
        this.timerField.setEnterHandler(this::setTime);
        this.timerField.setInputValidator(InputValidator.DIGIT);
        this.minField = this.addRenderableWidget(new GuiTextField(this, 96, 43, 72, 11));
        this.minField.setMaxLength(10);
        this.minField.setEnterHandler(this::setMinThreshold);
        this.minField.setInputValidator(InputValidator.SCI_NOTATION);
        this.maxField = this.addRenderableWidget(new GuiTextField(this, 96, 58, 72, 11));
        this.maxField.setMaxLength(10);
        this.maxField.setEnterHandler(this::setMaxThreshold);
        this.maxField.setInputValidator(InputValidator.SCI_NOTATION);
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        if (((TileEntityLaserAmplifier)this.tile).getDelay() > 0) {
            this.drawTextScaledBound(guiGraphics, (Component)MekanismLang.DELAY.translate(((TileEntityLaserAmplifier)this.tile).getDelay()), 26.0f, 30.0f, this.titleTextColor(), 68.0f);
        } else {
            this.drawTextScaledBound(guiGraphics, (Component)MekanismLang.NO_DELAY.translate(), 26.0f, 30.0f, this.titleTextColor(), 68.0f);
        }
        this.drawTextScaledBound(guiGraphics, (Component)MekanismLang.MIN.translate(EnergyDisplay.of(((TileEntityLaserAmplifier)this.tile).getMinThreshold())), 26.0f, 45.0f, this.titleTextColor(), 68.0f);
        this.drawTextScaledBound(guiGraphics, (Component)MekanismLang.MAX.translate(EnergyDisplay.of(((TileEntityLaserAmplifier)this.tile).getMaxThreshold())), 26.0f, 60.0f, this.titleTextColor(), 68.0f);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    private FloatingLong parseFloatingLong(GuiTextField textField) {
        String text = textField.getText();
        if (text.contains("E")) {
            text = new BigDecimal(text).toPlainString();
        }
        return FloatingLong.parseFloatingLong(text);
    }

    private void setMinThreshold() {
        if (!this.minField.getText().isEmpty()) {
            try {
                PacketUtils.sendToServer(new PacketGuiSetEnergy(PacketGuiSetEnergy.GuiEnergyValue.MIN_THRESHOLD, ((TileEntityLaserAmplifier)this.tile).getBlockPos(), MekanismUtils.convertToJoules(this.parseFloatingLong(this.minField))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.minField.setText("");
        }
    }

    private void setMaxThreshold() {
        if (!this.maxField.getText().isEmpty()) {
            try {
                PacketUtils.sendToServer(new PacketGuiSetEnergy(PacketGuiSetEnergy.GuiEnergyValue.MAX_THRESHOLD, ((TileEntityLaserAmplifier)this.tile).getBlockPos(), MekanismUtils.convertToJoules(this.parseFloatingLong(this.maxField))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.maxField.setText("");
        }
    }

    private void setTime() {
        if (!this.timerField.getText().isEmpty()) {
            try {
                PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SET_TIME, (BlockEntity)this.tile, Integer.parseInt(this.timerField.getText())));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.timerField.setText("");
        }
    }
}

