/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.VirtualSlotContainerScreen;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.GuiVirtualSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiWarningTab;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.IGUIWindow;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.IVirtualSlot;
import mekanism.common.inventory.container.slot.InventoryContainerSlot;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.IWarningTracker;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.collection.LRU;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiMekanism<CONTAINER extends AbstractContainerMenu>
extends VirtualSlotContainerScreen<CONTAINER>
implements IGuiWrapper,
IFancyFontRenderer {
    public static final ResourceLocation BASE_BACKGROUND = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "base.png");
    public static final ResourceLocation SHADOW = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "shadow.png");
    public static final ResourceLocation BLUR = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "blur.png");
    protected boolean dynamicSlots;
    protected boolean initialFocusSet;
    protected final LRU<GuiWindow> windows = new LRU();
    public boolean switchingToRecipeViewer;
    @Nullable
    private IWarningTracker warningTracker;
    private boolean hasClicked = false;
    public static int maxZOffset;

    protected GuiMekanism(CONTAINER container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    @Override
    @NotNull
    public BooleanSupplier trackWarning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        if (this.warningTracker == null) {
            this.warningTracker = new WarningTracker();
        }
        return this.warningTracker.trackWarning(type, warningSupplier);
    }

    public void removed() {
        if (!this.switchingToRecipeViewer) {
            this.windows.forEach(GuiWindow::close);
            super.removed();
        }
    }

    protected void init() {
        super.init();
        if (this.warningTracker != null) {
            this.warningTracker.clearTrackedWarnings();
        }
        this.addGuiElements();
        if (this.warningTracker != null) {
            this.addWarningTab(this.warningTracker);
        }
        this.initPinnedWindows();
    }

    protected void initPinnedWindows() {
        if (this.windows.isEmpty()) {
            for (GuiEventListener child : this.children()) {
                if (!(child instanceof GuiElement)) continue;
                GuiElement element = (GuiElement)child;
                element.openPinnedWindows();
            }
        }
    }

    protected void addWarningTab(IWarningTracker warningTracker) {
        this.addRenderableWidget(new GuiWarningTab(this, warningTracker, 109));
    }

    protected void addGuiElements() {
        if (this.dynamicSlots) {
            this.addSlots();
        }
    }

    protected void setInitialFocus(@NotNull GuiEventListener listener) {
        if (!this.initialFocusSet) {
            super.setInitialFocus(listener);
            this.initialFocusSet = true;
        }
    }

    protected <T extends GuiElement> T addElement(T element) {
        this.renderables.add(element);
        this.children().add(element);
        return element;
    }

    protected <T extends GuiElement> T addRenderableWidget(T element) {
        return this.addElement(element);
    }

    public void containerTick() {
        super.containerTick();
        for (GuiEventListener child : this.children()) {
            if (!(child instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)child;
            element.tick();
        }
        this.windows.forEach(GuiElement::tick);
    }

    protected void renderTitleText(GuiGraphics guiGraphics) {
        this.drawTitleText(guiGraphics, this.title, this.titleLabelY);
    }

    protected ResourceLocation getButtonLocation(String name) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, name + ".png");
    }

    @Override
    @NotNull
    public ItemStack getCarriedItem() {
        return this.getMenu().getCarried();
    }

    @Nullable
    private <NAVIGATION extends FocusNavigationEvent> ComponentPath handleNavigationWithWindows(NAVIGATION navigation, BiFunction<ContainerEventHandler, NAVIGATION, @Nullable ComponentPath> handleNavigation) {
        ComponentPath.Path path;
        List<GuiWindow> combinedChildren;
        GuiWindow topWindow = this.windows.head();
        if (topWindow.getInteractionStrategy().allowAll()) {
            combinedChildren = new ArrayList<GuiWindow>(this.windows);
            combinedChildren.addAll(this.children());
        } else {
            combinedChildren = List.of(topWindow);
        }
        ContainerEventHandler handlerWithWindows = new ContainerEventHandler(){

            @NotNull
            public List<? extends GuiEventListener> children() {
                return combinedChildren;
            }

            public boolean isDragging() {
                return GuiMekanism.this.isDragging();
            }

            public void setDragging(boolean dragging) {
            }

            @Nullable
            public GuiEventListener getFocused() {
                return GuiMekanism.this.getFocused();
            }

            public void setFocused(@Nullable GuiEventListener focused) {
            }

            @NotNull
            public ScreenRectangle getRectangle() {
                return GuiMekanism.this.getRectangle();
            }
        };
        ComponentPath componentPath = handleNavigation.apply(handlerWithWindows, navigation);
        if (componentPath == null) {
            return null;
        }
        if (componentPath instanceof ComponentPath.Path && (path = (ComponentPath.Path)componentPath).component() == handlerWithWindows) {
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)path.childPath());
        }
        return componentPath;
    }

    @Nullable
    public ComponentPath handleTabNavigation(@NotNull FocusNavigationEvent.TabNavigation navigation) {
        if (this.windows.isEmpty()) {
            return super.handleTabNavigation(navigation);
        }
        return this.handleNavigationWithWindows(navigation, ContainerEventHandler::handleTabNavigation);
    }

    @Nullable
    public ComponentPath handleArrowNavigation(@NotNull FocusNavigationEvent.ArrowNavigation navigation) {
        if (this.windows.isEmpty()) {
            return super.handleArrowNavigation(navigation);
        }
        return this.handleNavigationWithWindows(navigation, ContainerEventHandler::handleArrowNavigation);
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        return this.getWindowHovering(mouseX, mouseY) == null && super.hasClickedOutside(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton);
    }

    protected void repositionElements() {
        this.switchingToRecipeViewer = false;
        super.repositionElements();
    }

    protected void rebuildWidgets() {
        record PreviousElement(int index, GuiElement element, boolean wasFocus) {
        }
        ArrayList<PreviousElement> prevElements = new ArrayList<PreviousElement>();
        GuiEventListener previousFocused = this.getFocused();
        for (int i = 0; i < this.children().size(); ++i) {
            boolean wasPreviousFocus;
            GuiEventListener widget = (GuiEventListener)this.children().get(i);
            if (!(widget instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)widget;
            boolean bl = wasPreviousFocus = element == previousFocused;
            if (!wasPreviousFocus && !element.hasPersistentData()) continue;
            prevElements.add(new PreviousElement(i, element, wasPreviousFocus));
        }
        int prevLeft = this.leftPos;
        int prevTop = this.topPos;
        super.rebuildWidgets();
        for (GuiWindow window : this.windows) {
            window.resize(prevLeft, prevTop, this.leftPos, this.topPos);
        }
        int childCount = this.children().size();
        for (PreviousElement e : prevElements) {
            GuiEventListener widget;
            if (e.index() >= childCount || (widget = (GuiEventListener)this.children().get(e.index())).getClass() != e.element().getClass()) continue;
            ((GuiElement)widget).syncFrom(e.element());
            if (!e.wasFocus()) continue;
            this.setFocused(widget);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int zOffset;
        PoseStack pose = guiGraphics.pose();
        pose.translate(0.0f, 0.0f, 300.0f);
        for (Object c : this.children()) {
            if (!(c instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)c;
            element.onDrawBackground(guiGraphics, mouseX, mouseY, MekanismRenderer.getPartialTick());
        }
        this.drawForegroundText(guiGraphics, mouseX, mouseY);
        maxZOffset = zOffset = 200;
        for (GuiEventListener widget : this.children()) {
            if (!(widget instanceof GuiElement)) continue;
            GuiElement element = (GuiElement)widget;
            pose.pushPose();
            element.onRenderForeground(guiGraphics, mouseX, mouseY, zOffset, zOffset);
            pose.popPose();
        }
        LRU.LRUIterator iter = this.getWindowsDescendingIterator();
        while (iter.hasNext()) {
            GuiWindow overlay = (GuiWindow)iter.next();
            zOffset = maxZOffset + 150;
            pose.pushPose();
            overlay.onRenderForeground(guiGraphics, mouseX, mouseY, zOffset, zOffset);
            if (iter.hasNext()) {
                overlay.renderBlur(guiGraphics);
            }
            pose.popPose();
        }
        GuiElement tooltipElement = this.getWindowHovering(mouseX, mouseY);
        if (tooltipElement == null) {
            tooltipElement = (GuiElement)GuiUtils.findChild(this.children(), mouseX, mouseY, (child, x, y) -> child instanceof GuiElement && child.isMouseOver(x, y));
        }
        pose.translate(0.0f, 0.0f, (float)maxZOffset);
        pose.translate((float)(-this.leftPos), (float)(-this.topPos), 0.0f);
        if (tooltipElement != null) {
            tooltipElement.renderToolTip(guiGraphics, mouseX, mouseY);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        pose.translate((float)this.leftPos, (float)this.topPos, 0.0f);
        pose.translate(0.0f, 0.0f, 200.0f);
    }

    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    @NotNull
    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        GuiWindow window = this.getWindowHovering(mouseX, mouseY);
        return window == null ? super.getChildAt(mouseX, mouseY) : Optional.of(window);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        boolean windowScroll;
        GuiWindow top = this.windows.peek();
        if (top != null && ((windowScroll = top.mouseScrolled(mouseX, mouseY, xDelta, yDelta)) || !top.getInteractionStrategy().allowAll())) {
            return windowScroll;
        }
        return super.mouseScrolled(mouseX, mouseY, xDelta, yDelta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.hasClicked = true;
        GuiWindow top = this.windows.peek();
        for (GuiWindow overlay : this.windows) {
            if (!overlay.mouseClicked(mouseX, mouseY, button)) continue;
            if (this.windows.contains(overlay)) {
                this.setFocused((GuiEventListener)overlay);
                if (button == 0) {
                    this.setDragging(true);
                }
                if (top != overlay) {
                    top.onFocusLost();
                    this.windows.moveUp(overlay);
                    overlay.onFocused();
                }
            }
            return true;
        }
        GuiEventListener clickedChild = GuiUtils.findChild(this.children(), mouseX, mouseY, button, GuiEventListener::mouseClicked);
        if (clickedChild != null) {
            this.setFocused(clickedChild);
            if (button == 0) {
                this.setDragging(true);
            }
            return true;
        }
        this.clearFocus();
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.hasClicked) {
            for (GuiWindow w : this.windows) {
                w.onRelease(mouseX, mouseY);
            }
            return super.mouseReleased(mouseX, mouseY, button);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        for (GuiWindow window : this.windows) {
            if (!window.keyPressed(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return GuiUtils.checkChildren(this.children(), keyCode, scanCode, modifiers, (child, k, s, m) -> child instanceof GuiElement && child.keyPressed(k, s, m)) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        for (GuiWindow window : this.windows) {
            if (!window.charTyped(c, keyCode)) continue;
            return true;
        }
        return GuiUtils.checkChildrenChar(this.children(), c, keyCode, (child, ch, k) -> child instanceof GuiElement && child.charTyped(ch, k)) || super.charTyped(c, keyCode);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseXOld, double mouseYOld) {
        super.mouseDragged(mouseX, mouseY, button, mouseXOld, mouseYOld);
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, mouseXOld, mouseYOld);
    }

    @Override
    @Deprecated
    @Nullable
    protected Slot findSlot(double mouseX, double mouseY) {
        boolean checkedWindow = false;
        boolean overNoButtons = false;
        GuiWindow window = null;
        for (Slot slot : this.menu.slots) {
            if (!slot.isActive()) continue;
            boolean virtual = slot instanceof IVirtualSlot;
            int xPos = slot.x;
            int yPos = slot.y;
            if (virtual) {
                IVirtualSlot virtualSlot = (IVirtualSlot)slot;
                if (!this.isVirtualSlotAvailable(virtualSlot)) continue;
                xPos = virtualSlot.getActualX();
                yPos = virtualSlot.getActualY();
            }
            if (!super.isHovering(xPos, yPos, 16, 16, mouseX, mouseY)) continue;
            if (!checkedWindow) {
                checkedWindow = true;
                window = this.getWindowHovering(mouseX, mouseY);
                overNoButtons = this.overNoButtons(window, mouseX, mouseY);
            }
            if (!overNoButtons || !slot.isActive()) continue;
            if (window == null) {
                return slot;
            }
            if (!virtual) continue;
            for (GuiElement child : window.children()) {
                GuiVirtualSlot v;
                if (!(child instanceof GuiVirtualSlot) || !(v = (GuiVirtualSlot)child).isElementForSlot((IVirtualSlot)slot)) continue;
                return slot;
            }
        }
        return null;
    }

    @Override
    protected boolean isMouseOverSlot(@NotNull Slot slot, double mouseX, double mouseY) {
        if (slot instanceof IVirtualSlot) {
            int yPos;
            int xPos;
            IVirtualSlot virtualSlot = (IVirtualSlot)slot;
            if (this.isVirtualSlotAvailable(virtualSlot) && super.isHovering(xPos = virtualSlot.getActualX(), yPos = virtualSlot.getActualY(), 16, 16, mouseX, mouseY)) {
                GuiWindow window = this.getWindowHovering(mouseX, mouseY);
                if (window == null) {
                    return this.overNoButtons(null, mouseX, mouseY);
                }
                for (GuiElement child : window.children()) {
                    GuiVirtualSlot v;
                    if (!(child instanceof GuiVirtualSlot) || !(v = (GuiVirtualSlot)child).isElementForSlot(virtualSlot)) continue;
                    return this.overNoButtons(window, mouseX, mouseY);
                }
            }
            return false;
        }
        return this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY);
    }

    private boolean overNoButtons(@Nullable GuiWindow window, double mouseX, double mouseY) {
        if (window == null) {
            return GuiMekanism.overNoButtons(this.children(), mouseX, mouseY);
        }
        return GuiMekanism.overNoButtons(window.children(), mouseX, mouseY);
    }

    private static boolean overNoButtons(List<? extends GuiEventListener> children, double mouseX, double mouseY) {
        for (GuiEventListener guiEventListener : children) {
            if (!guiEventListener.isMouseOver(mouseX, mouseY)) continue;
            return false;
        }
        return true;
    }

    private boolean isVirtualSlotAvailable(IVirtualSlot virtualSlot) {
        GuiWindow linkedWindow;
        IGUIWindow iGUIWindow = virtualSlot.getLinkedWindow();
        return !(iGUIWindow instanceof GuiWindow) || this.windows.contains(linkedWindow = (GuiWindow)iGUIWindow);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        return super.isHovering(x, y, width, height, mouseX, mouseY) && this.getWindowHovering(mouseX, mouseY) == null && this.overNoButtons(null, mouseX, mouseY);
    }

    protected void addSlots() {
        int size = this.menu.slots.size();
        for (int i = 0; i < size; ++i) {
            Slot slot = (Slot)this.menu.slots.get(i);
            if (slot instanceof InventoryContainerSlot) {
                SlotType type;
                InventoryContainerSlot containerSlot = (InventoryContainerSlot)slot;
                ContainerSlotType slotType = containerSlot.getSlotType();
                DataType dataType = this.findDataType(containerSlot);
                if (dataType != null) {
                    type = SlotType.get(dataType);
                } else if (slotType == ContainerSlotType.INPUT || slotType == ContainerSlotType.OUTPUT || slotType == ContainerSlotType.EXTRA) {
                    type = SlotType.NORMAL;
                } else if (slotType == ContainerSlotType.POWER) {
                    type = SlotType.POWER;
                } else {
                    if (slotType != ContainerSlotType.NORMAL && slotType != ContainerSlotType.VALIDITY) continue;
                    type = SlotType.NORMAL;
                }
                GuiSlot guiSlot = new GuiSlot(type, this, slot.x - 1, slot.y - 1);
                containerSlot.addWarnings(guiSlot);
                SlotOverlay slotOverlay = containerSlot.getSlotOverlay();
                if (slotOverlay != null) {
                    guiSlot.with(slotOverlay);
                }
                if (slotType == ContainerSlotType.VALIDITY) {
                    int index = i;
                    guiSlot.validity(() -> this.checkValidity(index));
                }
                this.addRenderableWidget(guiSlot);
                continue;
            }
            this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, slot.x - 1, slot.y - 1));
        }
    }

    @Nullable
    protected DataType findDataType(InventoryContainerSlot slot) {
        MekanismTileContainer container;
        Object object = this.menu;
        if (object instanceof MekanismTileContainer && (object = (container = (MekanismTileContainer)object).getTileEntity()) instanceof ISideConfiguration) {
            ISideConfiguration sideConfig = (ISideConfiguration)object;
            return sideConfig.getActiveDataType(slot.getInventorySlot());
        }
        return null;
    }

    protected ItemStack checkValidity(int slotIndex) {
        return ItemStack.EMPTY;
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        MekanismRenderer.resetColor(guiGraphics);
        if (this.width < 8 || this.height < 8) {
            Mekanism.logger.warn("Gui: {}, was too small to draw the background of. Unable to draw a background for a gui smaller than 8 by 8.", (Object)this.getClass().getSimpleName());
            return;
        }
        GuiUtils.renderBackgroundTexture(guiGraphics, BASE_BACKGROUND, 4, 4, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, 256, 256);
    }

    @Override
    public Font getFont() {
        return this.font == null ? this.minecraft.font : this.font;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(0.0f, 0.0f, -500.0f);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        pose.popPose();
    }

    @Override
    public boolean currentlyQuickCrafting() {
        return this.isQuickCrafting && !this.quickCraftSlots.isEmpty();
    }

    @Override
    public void addWindow(GuiWindow window) {
        GuiWindow top = this.windows.peek();
        if (top != null) {
            top.onFocusLost();
        }
        this.windows.add(window);
        window.onFocused();
    }

    @Override
    public void removeWindow(GuiWindow window) {
        if (!this.windows.isEmpty()) {
            GuiWindow top = this.windows.head();
            this.windows.remove(window);
            if (window == top) {
                window.onFocusLost();
                GuiWindow newTop = this.windows.peek();
                if (newTop == null) {
                    this.lastWindowRemoved();
                } else {
                    newTop.onFocused();
                }
                this.setFocused((GuiEventListener)newTop);
            }
        }
    }

    protected void lastWindowRemoved() {
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof MekanismContainer) {
            MekanismContainer container = (MekanismContainer)abstractContainerMenu;
            container.setSelectedWindow(null);
        }
    }

    @Override
    public void setSelectedWindow(SelectedWindowData selectedWindow) {
        AbstractContainerMenu abstractContainerMenu = this.menu;
        if (abstractContainerMenu instanceof MekanismContainer) {
            MekanismContainer container = (MekanismContainer)abstractContainerMenu;
            container.setSelectedWindow(selectedWindow);
        }
    }

    @Override
    @Nullable
    public GuiWindow getWindowHovering(double mouseX, double mouseY) {
        for (GuiWindow w : this.windows) {
            if (!w.isMouseOver(mouseX, mouseY)) continue;
            return w;
        }
        return null;
    }

    public Collection<GuiWindow> getWindows() {
        return this.windows;
    }

    public LRU.LRUIterator getWindowsDescendingIterator() {
        return this.windows.descendingIterator();
    }
}

