/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.gear.IModule;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.custom.module.GuiModuleScreen;
import mekanism.client.gui.element.scroll.GuiModuleScrollList;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.window.GuiMekaSuitHelmetOptions;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import mekanism.common.content.gear.ModuleConfigItem;
import mekanism.common.inventory.container.ModuleTweakerContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketUpdateModuleSettings;
import mekanism.common.registries.MekanismItems;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.util.EnumUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GuiModuleTweaker
extends GuiMekanism<ModuleTweakerContainer> {
    private final ArmorPreview armorPreview = new ArmorPreview();
    private final Consumer<ModuleConfigItem<?>> saveCallback = configItem -> {
        IModule<?> module;
        if (this.moduleScreen != null && (module = this.moduleScreen.getCurrentModule()) != null && this.selected != -1) {
            int slotIndex = ((Slot)((ModuleTweakerContainer)this.menu).slots.get(this.selected)).getSlotIndex();
            PacketUtils.sendToServer(PacketUpdateModuleSettings.create(slotIndex, module.getData(), configItem));
        }
    };
    private GuiModuleScrollList scrollList;
    private GuiModuleScreen moduleScreen;
    private TranslationButton optionsButton;
    private int selected = -1;

    public GuiModuleTweaker(ModuleTweakerContainer container, Inventory inv, Component title) {
        super(container, inv, title);
        this.imageWidth = 248;
        this.imageHeight += 20;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.moduleScreen = this.addRenderableWidget(new GuiModuleScreen((IGuiWrapper)this, 138, 20, this.saveCallback, this.armorPreview));
        this.scrollList = this.addRenderableWidget(new GuiModuleScrollList(this, 30, 20, 108, 116, () -> this.getStack(this.selected), this::onModuleSelected));
        this.addRenderableWidget(new GuiElementHolder(this, 30, 136, 108, 18));
        this.optionsButton = this.addRenderableWidget(new TranslationButton((IGuiWrapper)this, 31, 137, 106, 16, MekanismLang.BUTTON_OPTIONS, (element, mouseX, mouseY) -> {
            ((GuiModuleTweaker)element.gui()).openOptions();
            return true;
        }));
        this.optionsButton.active = false;
        int size = ((ModuleTweakerContainer)this.menu).slots.size();
        for (int i = 0; i < size; ++i) {
            Slot slot = (Slot)((ModuleTweakerContainer)this.menu).slots.get(i);
            int index = i;
            if (this.selected == -1 && this.isValidItem(index)) {
                this.select(index);
            }
            this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, slot.x - 1, slot.y - 1).click((e, x, y) -> this.select(index), (Holder<SoundEvent>)MekanismSounds.BEEP).overlayColor(this.isValidItem(index) ? null : () -> -869059789).with(() -> index == this.selected ? SlotOverlay.SELECT : null));
        }
    }

    private void onModuleSelected(Module<?> module) {
        this.moduleScreen.setModule(module);
    }

    private void openOptions() {
        this.addWindow(new GuiMekaSuitHelmetOptions(this, this.imageWidth / 2 - 70, this.imageHeight / 2 - 45));
    }

    @Override
    public boolean keyPressed(int key, int i, int j) {
        if (super.keyPressed(key, i, j)) {
            return true;
        }
        if (this.selected != -1 && (this.isPreviousButton(key) || this.isNextButton(key))) {
            int curIndex = -1;
            IntArrayList selectable = new IntArrayList();
            int slots = ((ModuleTweakerContainer)this.menu).slots.size();
            for (int index = 0; index < slots; ++index) {
                if (!this.isValidItem(index)) continue;
                selectable.add(index);
                if (index != this.selected) continue;
                curIndex = selectable.size() - 1;
            }
            int targetIndex = this.isPreviousButton(key) ? (curIndex == 0 ? selectable.size() - 1 : curIndex - 1) : curIndex + 1;
            this.select(selectable.getInt(targetIndex % selectable.size()));
            return true;
        }
        return false;
    }

    private boolean isPreviousButton(int key) {
        return key == 265 || key == 263;
    }

    private boolean isNextButton(int key) {
        return key == 264 || key == 262;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.moduleScreen.onRelease(mouseX, mouseY);
        return super.mouseReleased(mouseX, mouseY, button);
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    private boolean select(int index) {
        if (this.isValidItem(index)) {
            this.selected = index;
            ItemStack stack = this.getStack(index);
            this.armorPreview.tryUpdateFull(stack);
            this.scrollList.updateItemAndList(stack);
            this.scrollList.clearSelection();
            this.optionsButton.active = stack.is(MekanismItems.MEKASUIT_HELMET);
            return true;
        }
        return false;
    }

    private boolean isValidItem(int index) {
        return ModuleTweakerContainer.isTweakableItem(this.getStack(index));
    }

    private ItemStack getStack(int index) {
        if (index == -1) {
            return ItemStack.EMPTY;
        }
        return ((Slot)((ModuleTweakerContainer)this.menu).slots.get(index)).getItem();
    }

    public static class ArmorPreview
    implements Supplier<LivingEntity> {
        private final Map<EquipmentSlot, Supplier<ItemStack>> lazyItems = new EnumMap<EquipmentSlot, Supplier<ItemStack>>(EquipmentSlot.class);
        private ArmorStand preview;

        protected ArmorPreview() {
            for (EquipmentSlot armorSlot : EnumUtils.ARMOR_SLOTS) {
                this.lazyItems.put(armorSlot, () -> {
                    ItemStack stack = Minecraft.getInstance().player.getItemBySlot(armorSlot);
                    if (stack.isEmpty()) {
                        return (switch (armorSlot) {
                            case EquipmentSlot.FEET -> MekanismItems.MEKASUIT_BOOTS;
                            case EquipmentSlot.LEGS -> MekanismItems.MEKASUIT_PANTS;
                            case EquipmentSlot.CHEST -> MekanismItems.MEKASUIT_BODYARMOR;
                            case EquipmentSlot.HEAD -> MekanismItems.MEKASUIT_HELMET;
                            default -> throw new IllegalStateException("Unknown armor slot: " + armorSlot.getName());
                        }).getItemStack();
                    }
                    return stack;
                });
            }
        }

        public void tryUpdateFull(ItemStack stack) {
            Item item;
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item;
                EquipmentSlot slot = armorItem.getEquipmentSlot();
                this.lazyItems.put(slot, () -> stack);
                this.updatePreview(slot, stack);
            }
        }

        public void updatePreview(EquipmentSlot slot, ItemStack stack) {
            if (this.preview != null) {
                this.preview.setItemSlot(slot, stack);
            }
        }

        public void resetToDefault(EquipmentSlot slot) {
            if (this.preview != null && this.lazyItems.containsKey(slot)) {
                this.updatePreview(slot, this.lazyItems.get(slot).get());
            }
        }

        @Override
        public LivingEntity get() {
            if (this.preview == null) {
                this.preview = new ArmorStand(EntityType.ARMOR_STAND, (Level)Minecraft.getInstance().level);
                this.preview.setNoBasePlate(true);
                for (Map.Entry<EquipmentSlot, Supplier<ItemStack>> entry : this.lazyItems.entrySet()) {
                    this.preview.setItemSlot(entry.getKey(), entry.getValue().get());
                }
            }
            return this.preview;
        }
    }
}

