/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import mekanism.api.math.MathUtils;
import mekanism.api.radial.RadialData;
import mekanism.api.radial.mode.INestedRadialMode;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.lib.ScrollIncrementer;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.radial.IGenericRadialModeItem;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketRadialModeChange;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuiRadialSelector
extends Screen {
    private static final ResourceLocation BACK_BUTTON = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_RADIAL, "back.png");
    private static final float DRAWS = 300.0f;
    private static final float INNER = 40.0f;
    private static final float OUTER = 100.0f;
    private static final float MIDDLE_DISTANCE = 70.0f;
    private static final float SELECT_RADIUS = 10.0f;
    private static final float SELECT_RADIUS_WITH_PARENT = 20.0f;
    private final ScrollIncrementer scrollIncrementer = new ScrollIncrementer(true);
    private final Deque<RadialData<?>> parents = new ArrayDeque();
    private final Supplier<Player> playerSupplier;
    private final EquipmentSlot slot;
    @NotNull
    private RadialData<?> radialData;
    private IRadialMode selection = null;
    private boolean overBackButton = false;
    private boolean updateOnClose = true;

    public GuiRadialSelector(EquipmentSlot slot, @NotNull RadialData<?> radialData, Supplier<Player> playerSupplier) {
        super((Component)MekanismLang.RADIAL_SCREEN.translate());
        this.slot = slot;
        this.radialData = radialData;
        this.playerSupplier = playerSupplier;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float centerX = (float)guiGraphics.guiWidth() / 2.0f;
        float centerY = (float)guiGraphics.guiHeight() / 2.0f;
        this.render(guiGraphics, mouseX, mouseY, centerX, centerY, this.radialData);
    }

    private <MODE extends IRadialMode> void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float centerX, float centerY, RadialData<MODE> radialData) {
        List<MODE> modes = radialData.getModes();
        int activeModes = modes.size();
        if (activeModes == 0) {
            RadialData<?> parent = this.parents.pollLast();
            if (parent == null) {
                this.onClose();
            } else {
                this.radialData = parent;
            }
            return;
        }
        float angleSize = 360.0f / (float)activeModes;
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate(centerX, centerY, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawTorus(guiGraphics, 0.0f, 360.0f, 0.3f, 0.3f, 0.3f, 0.5f);
        MODE current = this.getCurrent(radialData);
        if (current == null) {
            current = radialData.getDefaultMode(modes);
        }
        int section = radialData.indexNullable(modes, current);
        if (current != null && section != -1) {
            float startAngle = -90.0f + 360.0f * (-0.5f + (float)section) / (float)activeModes;
            EnumColor color = current.color();
            if (color == null) {
                this.drawTorus(guiGraphics, startAngle, angleSize, 0.4f, 0.4f, 0.4f, 0.7f);
            } else {
                this.drawTorus(guiGraphics, startAngle, angleSize, color.getColor(0), color.getColor(1), color.getColor(2), 0.3f);
            }
        }
        double xDiff = (float)mouseX - centerX;
        double yDiff = (float)mouseY - centerY;
        double distanceFromCenter = Mth.length((double)xDiff, (double)yDiff);
        float f = this.parents.isEmpty() ? 10.0f : 20.0f;
        if (distanceFromCenter > (double)f) {
            float angle = (float)(57.2957763671875 * Mth.atan2((double)yDiff, (double)xDiff));
            float modeSize = 180.0f / (float)activeModes;
            this.drawTorus(guiGraphics, angle - modeSize, angleSize, 0.8f, 0.8f, 0.8f, 0.3f);
            float selectionAngle = StatUtils.wrapDegrees(angle + modeSize + 90.0f);
            int selectionDrawnPos = (int)(selectionAngle * ((float)activeModes / 360.0f));
            this.selection = (IRadialMode)modes.get(selectionDrawnPos);
            this.drawTorus(guiGraphics, -90.0f + 360.0f * (-0.5f + (float)selectionDrawnPos) / (float)activeModes, angleSize, 0.6f, 0.6f, 0.6f, 0.7f);
        } else {
            this.selection = null;
        }
        record PositionedText(float x, float y, Component text) {
        }
        ArrayList<PositionedText> textToDraw = new ArrayList<PositionedText>(this.parents.isEmpty() ? activeModes : activeModes + 1);
        if (!this.parents.isEmpty()) {
            boolean bl = this.overBackButton = distanceFromCenter <= 20.0;
            if (this.overBackButton) {
                this.drawTorus(guiGraphics, 0.0f, 360.0f, 0.0f, 20.0f, 0.8f, 0.8f, 0.8f, 0.3f);
            } else {
                this.drawTorus(guiGraphics, 0.0f, 360.0f, 0.0f, 20.0f, 0.3f, 0.3f, 0.3f, 0.5f);
            }
            guiGraphics.blit(BACK_BUTTON, -12, -18, 24, 24, 0.0f, 0.0f, 18, 18, 18, 18);
            textToDraw.add(new PositionedText(0.0f, 0.0f, (Component)MekanismLang.BACK.translate()));
        } else {
            this.overBackButton = false;
        }
        int position = 0;
        for (IRadialMode mode : modes) {
            float degrees = 270.0f + 360.0f * ((float)position++ / (float)activeModes);
            float angle = (float)Math.PI / 180 * degrees;
            float x = Mth.cos((float)angle) * 70.0f;
            float y = Mth.sin((float)angle) * 70.0f;
            guiGraphics.blit(mode.icon(), Math.round(x - 12.0f), Math.round(y - 20.0f), 24, 24, 0.0f, 0.0f, 18, 18, 18, 18);
            textToDraw.add(new PositionedText(x, y, mode.sliceName()));
        }
        boolean whiteRadialText = MekanismConfig.client.whiteRadialText.get();
        for (PositionedText toDraw : textToDraw) {
            pose.pushPose();
            pose.translate(toDraw.x, toDraw.y, 0.0f);
            pose.scale(0.6f, 0.6f, 0.6f);
            Component text = toDraw.text;
            if (whiteRadialText) {
                text = text.copy().withStyle(ChatFormatting.RESET);
            }
            GuiUtils.drawString(guiGraphics, this.font, text, (float)(-this.font.width((FormattedText)text)) / 2.0f, 8.0f, -855638017, true);
            pose.popPose();
        }
        pose.popPose();
    }

    public void removed() {
        if (this.updateOnClose) {
            this.updateSelection(this.radialData);
        }
        super.removed();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return deltaY != 0.0 && this.mouseScrolled(this.radialData, this.scrollIncrementer.scroll(deltaY)) || super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private <MODE extends IRadialMode> boolean mouseScrolled(RadialData<MODE> radialData, int shift) {
        MODE current;
        int index;
        if (shift == 0) {
            return true;
        }
        List<MODE> modes = radialData.getModes();
        if (!modes.isEmpty() && (index = radialData.indexNullable(modes, current = this.getCurrent(radialData))) != -1) {
            this.selection = (IRadialMode)MathUtils.getByIndexMod(modes, index + shift);
            this.updateSelection(radialData);
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateSelection(this.radialData);
        return true;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void drawTorus(GuiGraphics guiGraphics, float startAngle, float sizeAngle, float red, float green, float blue, float alpha) {
        this.drawTorus(guiGraphics, startAngle, sizeAngle, 40.0f, 100.0f, red, green, blue, alpha);
    }

    private void drawTorus(GuiGraphics guiGraphics, float startAngle, float sizeAngle, float inner, float outer, float red, float green, float blue, float alpha) {
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder vertexBuffer = Tesselator.getInstance().getBuilder();
        vertexBuffer.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION_COLOR);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        float draws = 300.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float degrees = startAngle + (float)i / 300.0f * 360.0f;
            float angle = (float)Math.PI / 180 * degrees;
            float cos = Mth.cos((float)angle);
            float sin = Mth.sin((float)angle);
            vertexBuffer.vertex(matrix4f, outer * cos, outer * sin, 0.0f).color(red, green, blue, alpha).endVertex();
            vertexBuffer.vertex(matrix4f, inner * cos, inner * sin, 0.0f).color(red, green, blue, alpha).endVertex();
            ++i;
        }
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)vertexBuffer.end());
    }

    @Nullable
    private <MODE extends IRadialMode> MODE getCurrent(RadialData<MODE> radialData) {
        ItemStack stack;
        Item item;
        Player player = this.playerSupplier.get();
        if (player != null && (item = (stack = player.getItemBySlot(this.slot)).getItem()) instanceof IGenericRadialModeItem) {
            IGenericRadialModeItem item2 = (IGenericRadialModeItem)item;
            return item2.getMode(stack, radialData);
        }
        return null;
    }

    private <MODE extends IRadialMode> void updateSelection(RadialData<MODE> radialData) {
        if (this.selection != null && this.playerSupplier.get() != null) {
            INestedRadialMode nested;
            IRadialMode iRadialMode = this.selection;
            if (iRadialMode instanceof INestedRadialMode && (nested = (INestedRadialMode)iRadialMode).hasNestedData()) {
                this.parents.push(radialData);
                this.radialData = nested.nestedData();
                this.selection = null;
            } else if (!this.selection.equals(this.getCurrent(radialData))) {
                int networkRepresentation;
                ArrayList<ResourceLocation> path = new ArrayList<ResourceLocation>(this.parents.size());
                RadialData<?> previousParent = null;
                for (RadialData<?> parent : this.parents) {
                    if (previousParent != null) {
                        path.add(parent.getIdentifier());
                    }
                    previousParent = parent;
                }
                if (previousParent != null) {
                    path.add(radialData.getIdentifier());
                }
                if ((networkRepresentation = radialData.tryGetNetworkRepresentation(this.selection)) != -1) {
                    PacketUtils.sendToServer(new PacketRadialModeChange(this.slot, path, networkRepresentation));
                }
            }
        } else if (this.overBackButton) {
            this.overBackButton = false;
            RadialData<?> parent = this.parents.pollLast();
            if (parent != null) {
                this.radialData = parent;
            }
        }
    }

    public boolean hasMatchingData(EquipmentSlot slot, RadialData<?> data) {
        if (this.slot == slot) {
            RadialData<?> firstData = this.parents.peekFirst();
            return firstData == null ? this.radialData.equals(data) : firstData.equals(data);
        }
        return false;
    }

    public void tryInheritCurrentPath(@Nullable Screen screen) {
        if (screen instanceof GuiRadialSelector) {
            INestedRadialMode nestedMode;
            GuiRadialSelector old = (GuiRadialSelector)screen;
            RadialData<?> previousParent = null;
            for (RadialData<?> parent : old.parents) {
                if (previousParent != null && this.radialData.getIdentifier().equals((Object)previousParent.getIdentifier())) {
                    INestedRadialMode nestedMode2 = this.radialData.fromIdentifier(parent.getIdentifier());
                    if (nestedMode2 == null || !nestedMode2.hasNestedData()) {
                        return;
                    }
                    this.parents.push(this.radialData);
                    this.radialData = nestedMode2.nestedData();
                }
                previousParent = parent;
            }
            if (previousParent != null && this.radialData.getIdentifier().equals((Object)previousParent.getIdentifier()) && (nestedMode = this.radialData.fromIdentifier(old.radialData.getIdentifier())) != null && nestedMode.hasNestedData()) {
                this.parents.push(this.radialData);
                this.radialData = nestedMode.nestedData();
                old.updateOnClose = false;
            }
        }
    }

    public boolean shouldHideCrosshair() {
        return !this.parents.isEmpty();
    }
}

