/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Divisor;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.List;
import java.util.function.Predicate;
import mekanism.common.Mekanism;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class GuiUtils {
    private GuiUtils() {
    }

    public static void renderExtendedTexture(GuiGraphics guiGraphics, ResourceLocation resource, int sideWidth, int sideHeight, int left, int top, int width, int height) {
        int textureWidth = 2 * sideWidth + 1;
        int textureHeight = 2 * sideHeight + 1;
        GuiUtils.blitNineSlicedSized(guiGraphics, resource, left, top, width, height, sideWidth, sideHeight, textureWidth, textureHeight, 0, 0, textureWidth, textureHeight);
    }

    public static void renderBackgroundTexture(GuiGraphics guiGraphics, ResourceLocation resource, int texSideWidth, int texSideHeight, int left, int top, int width, int height, int textureWidth, int textureHeight) {
        GuiUtils.blitNineSlicedSized(guiGraphics, resource, left, top, width, height, texSideWidth, texSideHeight, textureWidth, textureHeight, 0, 0, textureWidth, textureHeight);
    }

    public static void drawOutline(GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        GuiUtils.fill(guiGraphics, x, y, width, 1, color);
        GuiUtils.fill(guiGraphics, x, y + height - 1, width, 1, color);
        if (height > 2) {
            GuiUtils.fill(guiGraphics, x, y + 1, 1, height - 2, color);
            GuiUtils.fill(guiGraphics, x + width - 1, y + 1, 1, height - 2, color);
        }
    }

    public static void fill(GuiGraphics guiGraphics, RenderType renderType, int x, int y, int width, int height, int color) {
        if (width != 0 && height != 0) {
            guiGraphics.fill(renderType, x, y, x + width, y + height, color);
        }
    }

    public static void fill(GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        if (width != 0 && height != 0) {
            guiGraphics.fill(x, y, x + width, y + height, color);
        }
    }

    public static void drawBackdrop(GuiGraphics guiGraphics, Minecraft minecraft, int x, int y, int width, int alpha) {
        GuiUtils.drawBackdrop(guiGraphics, minecraft, x, y, width, 9, alpha);
    }

    public static void drawBackdrop(GuiGraphics guiGraphics, Minecraft minecraft, int x, int y, int width, int height, int alpha) {
        int backgroundColor = minecraft.options.getBackgroundColor(0.0f);
        if (backgroundColor != 0) {
            int argb = 0xFFFFFF | alpha << 24;
            guiGraphics.fill(x - 2, y - 2, x + width + 2, y + height + 2, FastColor.ARGB32.multiply((int)backgroundColor, (int)argb));
        }
    }

    public static void drawTiledSprite(GuiGraphics guiGraphics, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, TilingDirection tilingDirection) {
        GuiUtils.drawTiledSprite(guiGraphics, xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, textureWidth, textureHeight, zLevel, tilingDirection, true);
    }

    public static void drawTiledSprite(GuiGraphics guiGraphics, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, TilingDirection tilingDirection, boolean blend) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)sprite.atlasLocation());
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        if (blend) {
            RenderSystem.enableBlend();
        }
        BufferBuilder vertexBuffer = Tesselator.getInstance().getBuilder();
        vertexBuffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            float uLocalMax;
            float uLocalMin;
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uLocalDif = uDif * (float)maskRight / (float)textureWidth;
            if (tilingDirection.right) {
                uLocalMin = uMin;
                uLocalMax = uMax - uLocalDif;
            } else {
                uLocalMin = uMin + uLocalDif;
                uLocalMax = uMax;
            }
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float vLocalMax;
                float vLocalMin;
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vLocalDif = vDif * (float)maskTop / (float)textureHeight;
                if (tilingDirection.down) {
                    vLocalMin = vMin;
                    vLocalMax = vMax - vLocalDif;
                } else {
                    vLocalMin = vMin + vLocalDif;
                    vLocalMax = vMax;
                }
                vertexBuffer.vertex(matrix4f, (float)x, (float)(y + textureHeight), (float)zLevel).uv(uLocalMin, vLocalMax).endVertex();
                vertexBuffer.vertex(matrix4f, (float)shiftedX, (float)(y + textureHeight), (float)zLevel).uv(uLocalMax, vLocalMax).endVertex();
                vertexBuffer.vertex(matrix4f, (float)shiftedX, (float)(y + maskTop), (float)zLevel).uv(uLocalMax, vLocalMin).endVertex();
                vertexBuffer.vertex(matrix4f, (float)x, (float)(y + maskTop), (float)zLevel).uv(uLocalMin, vLocalMin).endVertex();
            }
        }
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)vertexBuffer.end());
        if (blend) {
            RenderSystem.disableBlend();
        }
    }

    public static <CHILD extends GuiEventListener> boolean checkChildren(List<? extends CHILD> children, Predicate<CHILD> checker) {
        return GuiUtils.findChild(children, checker) != null;
    }

    @Nullable
    public static <CHILD extends GuiEventListener> CHILD findChild(List<? extends CHILD> children, Predicate<CHILD> checker) {
        for (int i = children.size() - 1; i >= 0; --i) {
            GuiEventListener child = (GuiEventListener)children.get(i);
            if (!checker.test(child)) continue;
            return (CHILD)child;
        }
        return null;
    }

    public static <CHILD extends GuiEventListener> boolean checkChildren(List<? extends CHILD> children, double mouseX, double mouseY, MouseOverPredicate<CHILD> checker) {
        return GuiUtils.findChild(children, mouseX, mouseY, checker) != null;
    }

    @Nullable
    public static <CHILD extends GuiEventListener> CHILD findChild(List<? extends CHILD> children, double mouseX, double mouseY, MouseOverPredicate<CHILD> checker) {
        for (int i = children.size() - 1; i >= 0; --i) {
            GuiEventListener child = (GuiEventListener)children.get(i);
            if (!checker.test(child, mouseX, mouseY)) continue;
            return (CHILD)child;
        }
        return null;
    }

    @Nullable
    public static <CHILD extends GuiEventListener> CHILD findChild(List<? extends CHILD> children, double mouseX, double mouseY, int button, MouseClickedPredicate<CHILD> checker) {
        for (int i = children.size() - 1; i >= 0; --i) {
            GuiEventListener child = (GuiEventListener)children.get(i);
            if (!checker.test(child, mouseX, mouseY, button)) continue;
            return (CHILD)child;
        }
        return null;
    }

    public static <CHILD extends GuiEventListener> boolean checkChildren(List<? extends CHILD> children, int keyCode, int scanCode, int modifiers, KeyPressedPredicate<CHILD> checker) {
        for (int i = children.size() - 1; i >= 0; --i) {
            GuiEventListener child = (GuiEventListener)children.get(i);
            if (!checker.test(child, keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    public static <CHILD extends GuiEventListener> boolean checkChildrenChar(List<? extends CHILD> children, char c, int keyCode, CharTypedPredicate<CHILD> checker) {
        for (int i = children.size() - 1; i >= 0; --i) {
            GuiEventListener child = (GuiEventListener)children.get(i);
            if (!checker.test(child, c, keyCode)) continue;
            return true;
        }
        return false;
    }

    public static int drawString(GuiGraphics guiGraphics, Font font, Component component, float x, float y, int color, boolean drawShadow) {
        return guiGraphics.drawString(font, component.getVisualOrderText(), x, y, color, drawShadow);
    }

    public static void renderItem(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, float scale, Font font, @Nullable String text, boolean overlay) {
        if (!stack.isEmpty()) {
            try {
                PoseStack pose = guiGraphics.pose();
                pose.pushPose();
                if (scale != 1.0f) {
                    pose.translate((float)xAxis, (float)yAxis, 0.0f);
                    pose.scale(scale, scale, scale);
                    xAxis = 0;
                    yAxis = 0;
                }
                guiGraphics.renderItem(stack, xAxis, yAxis);
                if (overlay) {
                    pose.translate(0.0f, 0.0f, -25.0f);
                    guiGraphics.renderItemDecorations(font, stack, xAxis, yAxis, text);
                }
                pose.popPose();
            }
            catch (Exception e) {
                Mekanism.logger.error("Failed to render stack into gui: {}", (Object)stack, (Object)e);
            }
        }
    }

    public static void renderBorder(GuiGraphics guiGraphics, int x, int y, int boxWidth, int boxHeight, int color) {
        guiGraphics.hLine(x, x + boxWidth, y, color);
        guiGraphics.hLine(x, x + boxWidth, y + boxHeight, color);
        guiGraphics.vLine(x, y, y + boxHeight, color);
        guiGraphics.vLine(x + boxWidth, y, y + boxHeight, color);
    }

    public static void blitNineSlicedSized(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int sliceWidth, int sliceHeight, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        ProfilerFiller profiler = Minecraft.getInstance().getProfiler();
        profiler.push("blit setup");
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        Matrix4f matrix4f = guiGraphics.pose().last().pose();
        profiler.pop();
        BufferBuilder bufferbuilder = Tesselator.getInstance().getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        profiler.push("blitting");
        int cornerWidth = sliceWidth;
        int cornerHeight = sliceHeight;
        int edgeWidth = sliceWidth;
        int edgeHeight = sliceHeight;
        cornerWidth = Math.min(cornerWidth, width / 2);
        edgeWidth = Math.min(edgeWidth, width / 2);
        cornerHeight = Math.min(cornerHeight, height / 2);
        edgeHeight = Math.min(edgeHeight, height / 2);
        if (width == uWidth && height == vHeight) {
            GuiUtils.blit(bufferbuilder, matrix4f, x, y, uOffset, vOffset, width, height, textureWidth, textureHeight);
        } else if (height == vHeight) {
            GuiUtils.blit(bufferbuilder, matrix4f, x, y, uOffset, vOffset, cornerWidth, height, textureWidth, textureHeight);
            GuiUtils.blitRepeating(bufferbuilder, matrix4f, x + cornerWidth, y, width - edgeWidth - cornerWidth, height, uOffset + cornerWidth, vOffset, uWidth - edgeWidth - cornerWidth, vHeight, textureWidth, textureHeight);
            GuiUtils.blit(bufferbuilder, matrix4f, x + width - edgeWidth, y, uOffset + uWidth - edgeWidth, vOffset, edgeWidth, height, textureWidth, textureHeight);
        } else if (width == uWidth) {
            GuiUtils.blit(bufferbuilder, matrix4f, x, y, uOffset, vOffset, width, cornerHeight, textureWidth, textureHeight);
            GuiUtils.blitRepeating(bufferbuilder, matrix4f, x, y + cornerHeight, width, height - edgeHeight - cornerHeight, uOffset, vOffset + cornerHeight, uWidth, vHeight - edgeHeight - cornerHeight, textureWidth, textureHeight);
            GuiUtils.blit(bufferbuilder, matrix4f, x, y + height - edgeHeight, uOffset, vOffset + vHeight - edgeHeight, width, edgeHeight, textureWidth, textureHeight);
        } else {
            GuiUtils.blit(bufferbuilder, matrix4f, x, y, uOffset, vOffset, cornerWidth, cornerHeight, textureWidth, textureHeight);
            GuiUtils.blitRepeating(bufferbuilder, matrix4f, x + cornerWidth, y, width - edgeWidth - cornerWidth, cornerHeight, uOffset + cornerWidth, vOffset, uWidth - edgeWidth - cornerWidth, cornerHeight, textureWidth, textureHeight);
            GuiUtils.blit(bufferbuilder, matrix4f, x + width - edgeWidth, y, uOffset + uWidth - edgeWidth, vOffset, edgeWidth, cornerHeight, textureWidth, textureHeight);
            GuiUtils.blit(bufferbuilder, matrix4f, x, y + height - edgeHeight, uOffset, vOffset + vHeight - edgeHeight, cornerWidth, edgeHeight, textureWidth, textureHeight);
            GuiUtils.blitRepeating(bufferbuilder, matrix4f, x + cornerWidth, y + height - edgeHeight, width - edgeWidth - cornerWidth, edgeHeight, uOffset + cornerWidth, vOffset + vHeight - edgeHeight, uWidth - edgeWidth - cornerWidth, edgeHeight, textureWidth, textureHeight);
            GuiUtils.blit(bufferbuilder, matrix4f, x + width - edgeWidth, y + height - edgeHeight, uOffset + uWidth - edgeWidth, vOffset + vHeight - edgeHeight, edgeWidth, edgeHeight, textureWidth, textureHeight);
            GuiUtils.blitRepeating(bufferbuilder, matrix4f, x, y + cornerHeight, cornerWidth, height - edgeHeight - cornerHeight, uOffset, vOffset + cornerHeight, cornerWidth, vHeight - edgeHeight - cornerHeight, textureWidth, textureHeight);
            GuiUtils.blitRepeating(bufferbuilder, matrix4f, x + cornerWidth, y + cornerHeight, width - edgeWidth - cornerWidth, height - edgeHeight - cornerHeight, uOffset + cornerWidth, vOffset + cornerHeight, uWidth - edgeWidth - cornerWidth, vHeight - edgeHeight - cornerHeight, textureWidth, textureHeight);
            GuiUtils.blitRepeating(bufferbuilder, matrix4f, x + width - edgeWidth, y + cornerHeight, cornerWidth, height - edgeHeight - cornerHeight, uOffset + uWidth - edgeWidth, vOffset + cornerHeight, edgeWidth, vHeight - edgeHeight - cornerHeight, textureWidth, textureHeight);
        }
        profiler.pop();
        profiler.push("drawing");
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)bufferbuilder.end());
        profiler.pop();
    }

    public static void blitNineSlicedSized(GuiGraphics guiGraphics, ResourceLocation texture, int x, int y, int width, int height, int sliceSize, int uWidth, int vHeight, int uOffset, int vOffset, int textureWidth, int textureHeight) {
        GuiUtils.blitNineSlicedSized(guiGraphics, texture, x, y, width, height, sliceSize, sliceSize, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    private static void blit(BufferBuilder bufferbuilder, Matrix4f matrix4f, int pX, int pY, float pUOffset, float pVOffset, int pWidth, int pHeight, int pTextureWidth, int pTextureHeight) {
        bufferbuilder.vertex(matrix4f, (float)pX, (float)pY, 0.0f).uv((pUOffset + 0.0f) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight).endVertex();
        bufferbuilder.vertex(matrix4f, (float)pX, (float)(pY + pHeight), 0.0f).uv((pUOffset + 0.0f) / (float)pTextureWidth, (pVOffset + (float)pHeight) / (float)pTextureHeight).endVertex();
        bufferbuilder.vertex(matrix4f, (float)(pX + pWidth), (float)(pY + pHeight), 0.0f).uv((pUOffset + (float)pWidth) / (float)pTextureWidth, (pVOffset + (float)pHeight) / (float)pTextureHeight).endVertex();
        bufferbuilder.vertex(matrix4f, (float)(pX + pWidth), (float)pY, 0.0f).uv((pUOffset + (float)pWidth) / (float)pTextureWidth, (pVOffset + 0.0f) / (float)pTextureHeight).endVertex();
    }

    private static void blitRepeating(BufferBuilder bufferbuilder, Matrix4f matrix4f, int pX, int pY, int pWidth, int pHeight, int pUOffset, int pVOffset, int pSourceWidth, int pSourceHeight, int textureWidth, int textureHeight) {
        int i = pX;
        IntIterator intiterator = GuiUtils.slices(pWidth, pSourceWidth);
        while (intiterator.hasNext()) {
            int j = intiterator.nextInt();
            int k = (pSourceWidth - j) / 2;
            int l = pY;
            IntIterator intiterator1 = GuiUtils.slices(pHeight, pSourceHeight);
            while (intiterator1.hasNext()) {
                int i1 = intiterator1.nextInt();
                int j1 = (pSourceHeight - i1) / 2;
                GuiUtils.blit(bufferbuilder, matrix4f, i, l, pUOffset + k, pVOffset + j1, j, i1, textureWidth, textureHeight);
                l += i1;
            }
            i += j;
        }
    }

    private static IntIterator slices(int pTarget, int pTotal) {
        int i = Mth.positiveCeilDiv((int)pTarget, (int)pTotal);
        return new Divisor(pTarget, i);
    }

    public static enum TilingDirection {
        DOWN_RIGHT(true, true),
        DOWN_LEFT(true, false),
        UP_RIGHT(false, true),
        UP_LEFT(false, false);

        private final boolean down;
        private final boolean right;

        private TilingDirection(boolean down, boolean right) {
            this.down = down;
            this.right = right;
        }
    }

    public static interface MouseOverPredicate<ELEMENT> {
        public boolean test(ELEMENT var1, double var2, double var4);
    }

    public static interface MouseClickedPredicate<ELEMENT> {
        public boolean test(ELEMENT var1, double var2, double var4, int var6);
    }

    public static interface KeyPressedPredicate<ELEMENT> {
        public boolean test(ELEMENT var1, int var2, int var3, int var4);
    }

    public static interface CharTypedPredicate<ELEMENT> {
        public boolean test(ELEMENT var1, char var2, int var3);
    }
}

