/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.window.GuiColorWindow;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.lib.Color;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class GuiColorPickerSlot
extends GuiElement {
    private final Supplier<Color> supplier;
    private final Consumer<Color> consumer;
    private final boolean handlesAlpha;
    @Nullable
    private Tooltip lastTooltip = null;
    @Nullable
    private Color lastColor = null;

    public GuiColorPickerSlot(IGuiWrapper gui, int x, int y, boolean handlesAlpha, Supplier<Color> supplier, Consumer<Color> consumer) {
        super(gui, x, y, 18, 18);
        this.handlesAlpha = handlesAlpha;
        this.supplier = supplier;
        this.consumer = consumer;
        this.addChild(new GuiElementHolder(gui, this.relativeX, this.relativeY, 18, 18));
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        Color color = this.supplier.get();
        if (!color.equals(this.lastColor)) {
            this.lastColor = color;
            this.lastTooltip = TooltipUtils.create((Component)MekanismLang.GENERIC_HEX.translateColored(EnumColor.GRAY, TextUtils.hex(false, 3, color.rgb())));
        }
        this.setTooltip(this.lastTooltip);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        GuiUtils.fill(guiGraphics, this.relativeX + 1, this.relativeY + 1, this.width - 2, this.height - 2, this.supplier.get().argb());
    }

    public void onClick(double mouseX, double mouseY, int button) {
        GuiColorWindow window = new GuiColorWindow(this.gui(), this.getGuiWidth() / 2 - 80, this.getGuiHeight() / 2 - 60, this.handlesAlpha, this.consumer);
        window.setColor(this.supplier.get());
        this.gui().addWindow(window);
    }
}

