/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiElement
extends AbstractWidget
implements IFancyFontRenderer,
ContainerEventHandler {
    private static final int BUTTON_TEX_X = 200;
    private static final int BUTTON_TEX_Y = 60;
    private static final int BUTTON_INDIVIDUAL_TEX_Y = 20;
    public static final ResourceLocation WARNING_BACKGROUND_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "warning_background.png");
    public static final ResourceLocation WARNING_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "warning.png");
    public static final Minecraft minecraft = Minecraft.getInstance();
    protected ButtonBackground buttonBackground = ButtonBackground.NONE;
    private final List<GuiElement> children = new ArrayList<GuiElement>();
    private final List<GuiElement> positionOnlyChildren = new ArrayList<GuiElement>();
    private IGuiWrapper guiObj;
    @Nullable
    protected Holder<SoundEvent> clickSound;
    protected int relativeX;
    protected int relativeY;
    public boolean isOverlay;
    @Nullable
    private GuiElement focused;
    private boolean isDragging;

    public GuiElement(IGuiWrapper gui, int x, int y, int width, int height) {
        this(gui, x, y, width, height, (Component)Component.empty());
    }

    public GuiElement(IGuiWrapper gui, int x, int y, int width, int height, Component text) {
        super(gui.getGuiLeft() + x, gui.getGuiTop() + y, width, height, text);
        this.relativeX = x;
        this.relativeY = y;
        this.guiObj = gui;
    }

    public void updateWidgetNarration(@NotNull NarrationElementOutput output) {
    }

    public GuiElement setTooltip(ILangEntry langEntry) {
        this.setTooltip(TooltipUtils.create(langEntry));
        return this;
    }

    protected void clearTooltip() {
        this.setTooltip(null);
    }

    public int getRelativeX() {
        return this.relativeX;
    }

    public int getRelativeY() {
        return this.relativeY;
    }

    public void transferToNewGui(IGuiWrapper gui) {
        int prevLeft = this.getGuiLeft();
        int prevTop = this.getGuiTop();
        this.transferToNewGuiInternal(gui);
        this.resize(prevLeft, prevTop, this.getGuiLeft(), this.getGuiTop());
    }

    private void transferToNewGuiInternal(IGuiWrapper gui) {
        this.guiObj = gui;
        for (GuiElement guiElement : this.children) {
            guiElement.transferToNewGuiInternal(gui);
        }
        for (GuiElement child : this.positionOnlyChildren) {
            child.transferToNewGuiInternal(gui);
        }
    }

    protected <ELEMENT extends GuiElement> ELEMENT addChild(ELEMENT element) {
        this.children.add(element);
        if (this.isOverlay) {
            element.isOverlay = true;
        }
        return element;
    }

    protected <ELEMENT extends GuiElement> ELEMENT addPositionOnlyChild(ELEMENT element) {
        this.positionOnlyChildren.add(element);
        return element;
    }

    public final IGuiWrapper gui() {
        return this.guiObj;
    }

    public final int getGuiLeft() {
        return this.guiObj.getGuiLeft();
    }

    public final int getGuiTop() {
        return this.guiObj.getGuiTop();
    }

    public final int getGuiWidth() {
        return this.guiObj.getXSize();
    }

    public final int getGuiHeight() {
        return this.guiObj.getYSize();
    }

    @NotNull
    public ScreenRectangle getRectangle() {
        return new ScreenRectangle(this.getGuiLeft() + this.getButtonX(), this.getGuiTop() + this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
    }

    @NotNull
    protected ScreenRectangle getTooltipRectangle(int mouseX, int mouseY) {
        return this.getRectangle();
    }

    @NotNull
    public List<GuiElement> children() {
        return this.children;
    }

    public void visitWidgets(@NotNull Consumer<AbstractWidget> consumer) {
        super.visitWidgets(consumer);
        this.children.forEach(consumer);
    }

    public void tick() {
        this.children.forEach(GuiElement::tick);
    }

    public void resize(int prevLeft, int prevTop, int left, int top) {
        this.setPosition(this.getX() - prevLeft + left, this.getY() - prevTop + top);
        for (GuiElement guiElement : this.children) {
            guiElement.resize(prevLeft, prevTop, left, top);
        }
        for (GuiElement child : this.positionOnlyChildren) {
            child.resize(prevLeft, prevTop, left, top);
        }
    }

    public final boolean childrenContainsElement(Predicate<GuiElement> checker) {
        for (GuiElement child : this.children) {
            if (!child.containsElement(checker)) continue;
            return true;
        }
        return false;
    }

    public boolean containsElement(Predicate<GuiElement> checker) {
        return checker.test(this) || this.childrenContainsElement(checker);
    }

    public void move(int changeX, int changeY) {
        this.setPosition(this.getX() + changeX, this.getY() + changeY);
        this.relativeX += changeX;
        this.relativeY += changeY;
        for (GuiElement child : this.children) {
            child.move(changeX, changeY);
        }
        for (GuiElement child : this.positionOnlyChildren) {
            child.move(changeX, changeY);
        }
    }

    public void onWindowClose() {
        this.children.forEach(GuiElement::onWindowClose);
    }

    protected static ResourceLocation getButtonLocation(String name) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, name + ".png");
    }

    public boolean hasPersistentData() {
        return this.children.stream().anyMatch(GuiElement::hasPersistentData);
    }

    public void syncFrom(GuiElement element) {
        int numChildren = this.children.size();
        if (numChildren > 0) {
            for (int i = 0; i < element.children.size(); ++i) {
                GuiElement child;
                GuiElement prevChild = element.children.get(i);
                if (!prevChild.hasPersistentData() || i >= numChildren || (child = this.children.get(i)).getClass() != prevChild.getClass()) continue;
                child.syncFrom(prevChild);
            }
        }
    }

    public final void onRenderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, int zOffset, int totalOffset) {
        if (this.visible) {
            PoseStack pose = guiGraphics.pose();
            pose.translate(0.0f, 0.0f, (float)zOffset);
            GuiMekanism.maxZOffset = Math.max(totalOffset, GuiMekanism.maxZOffset);
            this.renderBackgroundOverlay(guiGraphics, mouseX, mouseY);
            for (GuiElement guiElement : this.children) {
                guiElement.renderShifted(guiGraphics, mouseX, mouseY, 0.0f);
            }
            for (GuiElement guiElement : this.children) {
                guiElement.onDrawBackground(guiGraphics, mouseX, mouseY, 0.0f);
            }
            this.renderForeground(guiGraphics, mouseX, mouseY);
            for (GuiElement child : this.children) {
                pose.pushPose();
                child.onRenderForeground(guiGraphics, mouseX, mouseY, 50, totalOffset + 50);
                pose.popPose();
            }
        }
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.drawButtonText(guiGraphics, mouseX, mouseY);
    }

    public void renderBackgroundOverlay(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void openPinnedWindows() {
        this.children.forEach(GuiElement::openPinnedWindows);
    }

    public void renderToolTip(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.updateTooltip(mouseX, mouseY);
        Tooltip tooltip = this.getTooltip();
        if (tooltip != null) {
            tooltip.refreshTooltipForNextRenderPass(true, this.isFocused(), this.getTooltipRectangle(mouseX, mouseY));
        }
        for (GuiElement child : this.children) {
            if (!child.isMouseOver(mouseX, mouseY)) continue;
            child.renderToolTip(guiGraphics, mouseX, mouseY);
        }
    }

    public void updateTooltip(int mouseX, int mouseY) {
    }

    public final boolean isDragging() {
        return this.isDragging;
    }

    public final void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }

    @NotNull
    public Optional<GuiEventListener> getChildAt(double mouseX, double mouseY) {
        if (this.checkWindows(mouseX, mouseY)) {
            return Optional.ofNullable(GuiUtils.findChild(this.children, mouseX, mouseY, GuiElement::isMouseOver));
        }
        return Optional.empty();
    }

    @Nullable
    public GuiElement getFocused() {
        return this.focused;
    }

    public boolean isFocused() {
        return super.isFocused() || this.getFocused() != null;
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        if (this.focused != null) {
            this.focused.setFocused(false);
        }
        if (listener instanceof GuiElement) {
            GuiElement child = (GuiElement)listener;
            child.setFocused(true);
            this.focused = child;
        } else {
            this.focused = null;
        }
    }

    private void clearFocus() {
        ComponentPath path = super.getCurrentFocusPath();
        if (path != null) {
            path.applyFocus(false);
        }
    }

    @Nullable
    public ComponentPath getCurrentFocusPath() {
        GuiElement currentFocus = this.getFocused();
        if (currentFocus != null) {
            return ComponentPath.path((ContainerEventHandler)this, (ComponentPath)currentFocus.getCurrentFocusPath());
        }
        if (this.isFocused()) {
            return ComponentPath.leaf((GuiEventListener)this);
        }
        return null;
    }

    @Nullable
    public ComponentPath nextFocusPath(@NotNull FocusNavigationEvent event) {
        if (!this.active || !this.visible) {
            return null;
        }
        if (!this.isFocused() && (event instanceof FocusNavigationEvent.ArrowNavigation ? this.supportsArrowNavigation() : (event instanceof FocusNavigationEvent.TabNavigation ? this.supportsTabNavigation() : event instanceof FocusNavigationEvent.InitialFocus))) {
            return ComponentPath.leaf((GuiEventListener)this);
        }
        return super.nextFocusPath(event);
    }

    protected boolean supportsTabNavigation() {
        return false;
    }

    protected boolean supportsArrowNavigation() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        GuiElement clickedChild = GuiUtils.findChild(this.children, mouseX, mouseY, button, GuiElement::mouseClicked);
        if (clickedChild != null) {
            this.setFocused((GuiEventListener)clickedChild);
            return true;
        }
        if (!this.children.isEmpty()) {
            this.clearFocus();
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return GuiUtils.checkChildren(this.children, keyCode, scanCode, modifiers, GuiElement::keyPressed) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        return GuiUtils.checkChildrenChar(this.children, c, keyCode, GuiElement::charTyped) || super.charTyped(c, keyCode);
    }

    public void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        for (GuiElement element : this.children) {
            element.onDrag(mouseX, mouseY, deltaX, deltaY);
        }
        super.onDrag(mouseX, mouseY, deltaX, deltaY);
    }

    public void onRelease(double mouseX, double mouseY) {
        this.setDragging(false);
        for (GuiElement element : this.children) {
            element.onRelease(mouseX, mouseY);
        }
        super.onRelease(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        for (int i = this.children.size() - 1; i >= 0; --i) {
            GuiElement child = this.children.get(i);
            if (!child.mouseScrolled(mouseX, mouseY, xDelta, yDelta)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, xDelta, yDelta);
    }

    @Override
    public Font getFont() {
        return this.guiObj.getFont();
    }

    @Override
    public final int getXSize() {
        return this.getWidth();
    }

    public void setButtonBackground(ButtonBackground buttonBackground) {
        this.buttonBackground = buttonBackground;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return this.isMouseOver(mouseX, mouseY);
    }

    protected int getButtonX() {
        return this.relativeX;
    }

    protected int getButtonY() {
        return this.relativeY;
    }

    protected int getButtonWidth() {
        return this.width;
    }

    protected int getButtonHeight() {
        return this.height;
    }

    protected boolean resetColorBeforeRender() {
        return true;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return super.isMouseOver(mouseX, mouseY) || GuiUtils.checkChildren(this.children, mouseX, mouseY, GuiElement::isMouseOver);
    }

    public final boolean isMouseOverCheckWindows(double mouseX, double mouseY) {
        boolean isHovering = this.isMouseOver(mouseX, mouseY);
        return this.checkWindows(mouseX, mouseY, isHovering);
    }

    protected final boolean checkWindows(double mouseX, double mouseY) {
        return this.checkWindows(mouseX, mouseY, true);
    }

    protected final boolean checkWindows(double mouseX, double mouseY, boolean isHovering) {
        GuiWindow window;
        if (isHovering && (window = this.guiObj.getWindowHovering(mouseX, mouseY)) != null && !window.childrenContainsElement(e -> e == this)) {
            isHovering = false;
        }
        return isHovering;
    }

    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonBackground != ButtonBackground.NONE) {
            this.drawButton(guiGraphics, mouseX, mouseY);
        }
    }

    public final void onDrawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public final void renderShifted(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.isHovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY < this.getY() + this.height;
            this.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate((float)this.getGuiLeft(), (float)this.getGuiTop(), 0.0f);
            this.renderShifted(guiGraphics, mouseX, mouseY, partialTicks);
            pose.popPose();
        }
    }

    public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public int getFGColor() {
        if (this.packedFGColor != -1) {
            return this.packedFGColor;
        }
        return this.active ? this.activeButtonTextColor() : this.inactiveButtonTextColor();
    }

    protected int getButtonTextColor(int mouseX, int mouseY) {
        return this.getFGColor();
    }

    protected void drawButtonText(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Component text = this.getMessage();
        if (!text.getString().isEmpty()) {
            int color = this.getButtonTextColor(mouseX, mouseY) | Mth.ceil((float)(this.alpha * 255.0f)) << 24;
            this.drawCenteredTextScaledBound(guiGraphics, text, this.width - 4, (float)this.height / 2.0f - 4.0f, color);
        }
    }

    protected int getButtonTextureY(boolean hoveredOrFocused) {
        if (!this.active) {
            return 0;
        }
        if (hoveredOrFocused) {
            return 2;
        }
        return 1;
    }

    protected void drawButton(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.resetColorBeforeRender()) {
            MekanismRenderer.resetColor(guiGraphics);
        }
        ResourceLocation texture = this.buttonBackground.getTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int i = this.getButtonTextureY(this.isMouseOverCheckWindows(mouseX, mouseY));
        GuiUtils.blitNineSlicedSized(guiGraphics, texture, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), 20, 4, 200, 20, 0, i * 20, 200, 60);
    }

    protected void renderExtendedTexture(GuiGraphics guiGraphics, ResourceLocation resource, int sideWidth, int sideHeight) {
        GuiUtils.renderExtendedTexture(guiGraphics, resource, sideWidth, sideHeight, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
    }

    protected void renderBackgroundTexture(GuiGraphics guiGraphics, ResourceLocation resource, int sideWidth, int sideHeight) {
        GuiUtils.renderBackgroundTexture(guiGraphics, resource, sideWidth, sideHeight, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), 256, 256);
    }

    public void playDownSound(@NotNull SoundManager soundHandler) {
        if (this.clickSound != null) {
            GuiElement.playClickSound(soundHandler, this.clickSound);
        }
    }

    protected static void playClickSound(Holder<SoundEvent> sound) {
        GuiElement.playClickSound(minecraft.getSoundManager(), sound);
    }

    private static void playClickSound(@NotNull SoundManager soundHandler, @NotNull Holder<SoundEvent> sound) {
        soundHandler.play((SoundInstance)SimpleSoundInstance.forUI(sound, (float)1.0f));
    }

    protected void drawTiledSprite(GuiGraphics guiGraphics, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, GuiUtils.TilingDirection tilingDirection) {
        GuiUtils.drawTiledSprite(guiGraphics, xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, 16, 16, 0, tilingDirection);
    }

    @Override
    public void drawCenteredTextScaledBound(GuiGraphics guiGraphics, Component text, float maxLength, float x, float y, int color) {
        IFancyFontRenderer.super.drawCenteredTextScaledBound(guiGraphics, text, maxLength, (float)this.relativeX + x, (float)this.relativeY + y, color);
    }

    public static enum ButtonBackground {
        DEFAULT(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "button.png")),
        DIGITAL(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "button_digital.png")),
        NONE(null);

        private final ResourceLocation texture;

        private ButtonBackground(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }

    @FunctionalInterface
    public static interface IClickable {
        public boolean onClick(GuiElement var1, double var2, double var4);
    }
}

