/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiSideHolder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public abstract class GuiInsetElement<DATA_SOURCE>
extends GuiSideHolder {
    protected final int border;
    protected final int innerWidth;
    protected final int innerHeight;
    protected final DATA_SOURCE dataSource;
    protected final ResourceLocation overlay;

    public GuiInsetElement(ResourceLocation overlay, IGuiWrapper gui, DATA_SOURCE dataSource, int x, int y, int height, int innerSize, boolean left) {
        super(gui, x, y, height, left, false);
        this.overlay = overlay;
        this.dataSource = dataSource;
        this.innerWidth = innerSize;
        this.innerHeight = innerSize;
        this.border = (this.width - this.innerWidth) / 2;
        this.clickSound = SoundEvents.UI_BUTTON_CLICK;
        this.active = true;
    }

    @Override
    public boolean isMouseOver(double xAxis, double yAxis) {
        return this.active && this.visible && xAxis >= (double)(this.getX() + this.border) && xAxis < (double)(this.getRight() - this.border) && yAxis >= (double)(this.getY() + this.border) && yAxis < (double)(this.getBottom() - this.border);
    }

    @Override
    protected int getButtonX() {
        return super.getButtonX() + this.border + (this.left ? 1 : -1);
    }

    @Override
    protected int getButtonY() {
        return super.getButtonY() + this.border;
    }

    @Override
    protected int getButtonWidth() {
        return this.innerWidth;
    }

    @Override
    protected int getButtonHeight() {
        return this.innerHeight;
    }

    protected ResourceLocation getOverlay() {
        return this.overlay;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.buttonBackground != GuiElement.ButtonBackground.NONE) {
            this.drawButton(guiGraphics, mouseX, mouseY);
        }
        this.drawBackgroundOverlay(guiGraphics);
    }

    protected void drawBackgroundOverlay(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.blit(this.getOverlay(), this.getButtonX(), this.getButtonY(), 0.0f, 0.0f, this.innerWidth, this.innerHeight, this.innerWidth, this.innerHeight);
    }
}

