/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import java.util.Optional;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.merged.MergedChemicalTank;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiChemicalBar;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerIngredientHelper;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.chemical.dynamic.IGasTracker;
import mekanism.common.capabilities.chemical.dynamic.IInfusionTracker;
import mekanism.common.capabilities.chemical.dynamic.IPigmentTracker;
import mekanism.common.capabilities.chemical.dynamic.ISlurryTracker;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiMergedChemicalBar<HANDLER extends IGasTracker & IInfusionTracker & ISlurryTracker>
extends GuiBar<GuiBar.IBarInfoHandler>
implements IRecipeViewerIngredientHelper {
    private final MergedChemicalTank chemicalTank;
    private final GuiChemicalBar<Gas, GasStack> gasBar;
    private final GuiChemicalBar<InfuseType, InfusionStack> infusionBar;
    private final GuiChemicalBar<Pigment, PigmentStack> pigmentBar;
    private final GuiChemicalBar<Slurry, SlurryStack> slurryBar;

    public GuiMergedChemicalBar(IGuiWrapper gui, HANDLER handler, final MergedChemicalTank chemicalTank, int x, int y, int width, int height, boolean horizontal) {
        super(TextureAtlas.LOCATION_BLOCKS, gui, new GuiBar.IBarInfoHandler(){

            @Nullable
            private IChemicalTank<?, ?> getCurrentTank() {
                return switch (chemicalTank.getCurrent()) {
                    default -> throw new IncompatibleClassChangeError();
                    case MergedChemicalTank.Current.EMPTY -> null;
                    case MergedChemicalTank.Current.GAS -> chemicalTank.getGasTank();
                    case MergedChemicalTank.Current.INFUSION -> chemicalTank.getInfusionTank();
                    case MergedChemicalTank.Current.PIGMENT -> chemicalTank.getPigmentTank();
                    case MergedChemicalTank.Current.SLURRY -> chemicalTank.getSlurryTank();
                };
            }

            @Override
            public Component getTooltip() {
                IChemicalTank<?, ?> currentTank = this.getCurrentTank();
                if (currentTank == null) {
                    return MekanismLang.EMPTY.translate();
                }
                if (currentTank.getStored() == Long.MAX_VALUE) {
                    return MekanismLang.GENERIC_STORED.translate(currentTank.getType(), MekanismLang.INFINITE);
                }
                return MekanismLang.GENERIC_STORED_MB.translate(currentTank.getType(), TextUtils.format(currentTank.getStored()));
            }

            @Override
            public double getLevel() {
                IChemicalTank<?, ?> currentTank = this.getCurrentTank();
                return currentTank == null ? 0.0 : (double)currentTank.getStored() / (double)currentTank.getCapacity();
            }
        }, x, y, width, height, horizontal);
        this.chemicalTank = chemicalTank;
        this.gasBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getGasTank(), handler.getGasTanks(null)), x, y, width, height, horizontal));
        this.infusionBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getInfusionTank(), ((IInfusionTracker)handler).getInfusionTanks(null)), x, y, width, height, horizontal));
        this.pigmentBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getPigmentTank(), ((IPigmentTracker)handler).getPigmentTanks(null)), x, y, width, height, horizontal));
        this.slurryBar = this.addPositionOnlyChild(new GuiChemicalBar(gui, GuiChemicalBar.getProvider(this.chemicalTank.getSlurryTank(), ((ISlurryTracker)handler).getSlurryTanks(null)), x, y, width, height, horizontal));
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        if (currentBar == null) {
            super.updateTooltip(mouseX, mouseY);
        } else {
            currentBar.updateTooltip(mouseX, mouseY);
        }
    }

    @Override
    void drawContentsChecked(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, double handlerLevel, boolean warning) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        if (currentBar != null) {
            currentBar.drawContentsChecked(guiGraphics, mouseX, mouseY, partialTicks, handlerLevel, warning);
        }
    }

    @Override
    protected void renderBarOverlay(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks, double handlerLevel) {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        if (currentBar == null) {
            return this.gasBar.mouseClicked(mouseX, mouseY, button) | this.infusionBar.mouseClicked(mouseX, mouseY, button) | this.pigmentBar.mouseClicked(mouseX, mouseY, button) | this.slurryBar.mouseClicked(mouseX, mouseY, button);
        }
        return currentBar.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public Optional<?> getIngredient(double mouseX, double mouseY) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        return currentBar == null ? Optional.empty() : currentBar.getIngredient(mouseX, mouseY);
    }

    @Override
    public Rect2i getIngredientBounds(double mouseX, double mouseY) {
        GuiChemicalBar<?, ?> currentBar = this.getCurrentBarNoFallback();
        return currentBar == null ? new Rect2i(this.getX() + 1, this.getY() + 1, this.width - 2, this.height - 2) : currentBar.getIngredientBounds(mouseX, mouseY);
    }

    @Nullable
    private GuiChemicalBar<?, ?> getCurrentBarNoFallback() {
        return switch (this.chemicalTank.getCurrent()) {
            case MergedChemicalTank.Current.GAS -> this.gasBar;
            case MergedChemicalTank.Current.INFUSION -> this.infusionBar;
            case MergedChemicalTank.Current.PIGMENT -> this.pigmentBar;
            case MergedChemicalTank.Current.SLURRY -> this.slurryBar;
            default -> null;
        };
    }
}

