/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import java.util.function.Supplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class GuiEntityPreview
extends GuiElement {
    private static final Vector3f PREVIEW_TRANSLATION = new Vector3f();
    private static final Quaternionf PREVIEW_ANGLE = new Quaternionf().rotateZ((float)Math.PI);
    private final Supplier<LivingEntity> preview;
    private final int scale;
    private final float xOffset;
    private final float yOffset;
    private float rotation;

    public GuiEntityPreview(IGuiWrapper gui, int x, int y, int size, Supplier<LivingEntity> preview) {
        this(gui, x, y, size, size, preview);
    }

    public GuiEntityPreview(IGuiWrapper gui, int x, int y, int width, int height, Supplier<LivingEntity> preview) {
        super(gui, x, y, width, height);
        int size = Math.min(this.width, this.height);
        this.scale = size / 2;
        this.xOffset = (float)this.width / 2.0f;
        this.yOffset = (float)(this.height - 2) - (float)(this.height - size) / 2.0f;
        this.preview = preview;
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderBackgroundTexture(guiGraphics, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        LivingEntity preview = this.preview.get();
        float oldBodyRot = preview.yBodyRot;
        float oldYRot = preview.getYRot();
        preview.yBodyRot = 180.0f + this.rotation * 20.0f;
        preview.setYRot(180.0f + this.rotation * 40.0f);
        InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (float)((float)this.relativeX + this.xOffset), (float)((float)this.relativeY + this.yOffset), (int)this.scale, (Vector3f)PREVIEW_TRANSLATION, (Quaternionf)PREVIEW_ANGLE, null, (LivingEntity)preview);
        preview.yBodyRot = oldBodyRot;
        preview.setYRot(oldYRot);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        this.setDragging(true);
    }

    @Override
    public void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        super.onDrag(mouseX, mouseY, deltaX, deltaY);
        if (this.isDragging()) {
            this.rotation = Mth.wrapDegrees((float)(this.rotation - (float)(deltaX / 10.0)));
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.rotation = Mth.wrapDegrees((float)(this.rotation + (float)deltaY));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }
}

