/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom;

import mekanism.api.text.ILangEntry;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class GuiResizeControls
extends GuiSideHolder {
    private static final Tooltip COMPENSATE = TooltipUtils.create((ILangEntry)MekanismLang.QIO_COMPENSATE_TOOLTIP);
    private final MekanismImageButton expandButton;
    private final MekanismImageButton shrinkButton;
    private int tooltipTicks;
    private static final ResourceLocation MINUS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "minus.png");
    private static final ResourceLocation PLUS = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "plus.png");

    public <GUI extends IGuiWrapper & ResizeController> GuiResizeControls(GUI gui, int y) {
        super(gui, -26, y, 39, true, false);
        this.expandButton = this.addChild(new MekanismImageButton(gui, this.relativeX + 4, this.relativeY + 5, 19, 9, 19, 9, PLUS, (element, mouseX, mouseY) -> this.handleResize(ResizeType.EXPAND_Y, Screen.hasShiftDown())));
        this.shrinkButton = this.addChild(new MekanismImageButton(gui, this.relativeX + 4, this.relativeY + 25, 19, 9, 19, 9, MINUS, (element, mouseX, mouseY) -> this.handleResize(ResizeType.SHRINK_Y, Screen.hasShiftDown())));
        this.updateButtonState();
        this.active = true;
    }

    @Override
    public void tick() {
        super.tick();
        this.tooltipTicks = Math.max(0, this.tooltipTicks - 1);
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        if (this.tooltipTicks > 0 && !this.expandButton.active) {
            this.setTooltip(COMPENSATE);
        } else {
            this.clearTooltip();
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawScaledCenteredTextScaledBound(guiGraphics, (Component)MekanismLang.HEIGHT.translate(), (float)this.relativeX + 13.5f, (float)this.relativeY + 15.5f, this.titleTextColor(), this.width - 4, 0.7f);
    }

    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        if (!this.expandButton.active && mouseX >= (double)this.expandButton.getX() && mouseX < (double)this.expandButton.getRight() && mouseY >= (double)this.expandButton.getY() && mouseY < (double)this.expandButton.getBottom()) {
            this.tooltipTicks = 100;
        }
    }

    @Override
    protected void colorTab(GuiGraphics guiGraphics) {
        MekanismRenderer.color(guiGraphics, SpecialColors.TAB_RESIZE_CONTROLS);
    }

    private boolean handleResize(ResizeType type, boolean adjustMax) {
        IGuiWrapper iGuiWrapper = this.gui();
        if (iGuiWrapper instanceof ResizeController) {
            ResizeController resizeHandler = (ResizeController)((Object)iGuiWrapper);
            resizeHandler.resize(type, adjustMax);
            this.updateButtonState();
            return true;
        }
        return false;
    }

    private void updateButtonState() {
        int index = this.getIndex();
        this.expandButton.active = index < QIOItemViewerContainer.getSlotsYMax();
        this.shrinkButton.active = index > 2;
    }

    private int getIndex() {
        return MekanismConfig.client.qioItemViewerSlotsY.get();
    }

    @FunctionalInterface
    public static interface ResizeController {
        public void resize(ResizeType var1, boolean var2);
    }

    public static enum ResizeType {
        EXPAND_X,
        EXPAND_Y,
        SHRINK_X,
        SHRINK_Y;

    }
}

